<?php
 namespace App\Http\Requests; use Illuminate\Foundation\Http\FormRequest; use Illuminate\Validation\Rule; class LdapSettingRequest extends FormRequest { public function authorize() { return true; } public function rules() { $id = $this->route('ldap'); return [ 'name' => [ 'required', Rule::unique('ldap_settings')->ignore($id), 'check_alphanum_under_hyphen', 'regex:/^[a-zA-Z\d]/', 'max:255', ], 'host' => [ 'required', 'max:255', ], 'port' => [ 'numeric', 'min:0', 'max:65535', ], 'user' => [ 'max:255', ], 'password' => [ 'max:160', ], 'dn' => [ 'required', 'max:255', ], 'filter' => [ 'max:255', ], 'groupid' => [ 'required', ], 'username_attr' => [ 'max:255', ], 'mail_attr' => [ 'max:255', ], 'employee_id_attr' => [ 'max:255', ], 'jpname_attr' => [ 'max:255', ], 'department_attr' => [ 'max:255', ], 'post_attr' => [ 'max:255', ], 'custom_data1_attr' => [ 'max:255', ], 'custom_data2_attr' => [ 'max:255', ], 'custom_data3_attr' => [ 'max:255', ], 'privilege_attr' => [ 'max:255', ], 'flow_group_attr' => [ 'max:255', ], 'comment_attr' => [ 'max:255', ], ]; } public function attributes() { return [ 'name' => '設定名', 'host' => 'ホスト', 'port' => 'ポート', 'user' => 'アカウント', 'password' => 'パスワード', 'dn' => 'ベースDN', 'filter' => 'フィルター', 'groupid' => '登録時所属グループ', 'username_attr' => 'ユーザ名属性', 'mail_attr' => 'メールアドレス属性', 'employee_id_attr' => '社員番号属性', 'jpname_attr' => '氏名属性', 'department_attr' => '部署属性', 'post_attr' => '役職属性', 'custom_data1_attr' => '任意データ1属性', 'custom_data2_attr' => '任意データ2属性', 'custom_data3_attr' => '任意データ3属性', 'privilege_attr' => '承認権限属性', 'flow_group_attr' => '承認グループ属性', 'comment_attr' => '備考属性', ]; } public function messages() { return [ 'max' => ':attributeが:max文字を超えています。', 'required' => ':attributeは必須です。', 'name.unique' => ':attributeが他の設定と重複しています。', 'name.check_alphanum_under_hyphen' => ':attributeには、英数字 - _ のみ使用可能です。', 'name.regex' => ':attributeの先頭は英数字である必要があります。', 'port.min' => ':attributeは:min以上を指定してください。', 'port.max' => ':attributeは:max以下を指定してください。', ]; } } 