<?php
declare(strict_types = 1); namespace App\Http\Requests; use App\Models\ManagedBookmark; use Illuminate\Foundation\Http\FormRequest; use Illuminate\Validation\Rule; class ManagedBookmarkRequest extends FormRequest { public function authorize() { return true; } public function rules() { $id = $this->route('managed_bookmark'); $name_min = ManagedBookmark::NAME_MIN; $name_max = ManagedBookmark::NAME_MAX; $bookmarks_max = ManagedBookmark::BOOKMARKS_NUM_MAX; $rules = []; switch ($this->method()) { case 'POST': case 'PUT': $rules = [ 'namebody' => [ 'required', "between:${name_min},${name_max}", 'check_alphanum_under_hyphen', 'regex:/^[a-zA-Z\d]/', ], 'name' => [ Rule::unique('managed_bookmarks')->ignore($id), ], 'bookmarks' => [ "max_bookmarks:${bookmarks_max}", ], ]; break; case 'DELETE': break; } return $rules; } public function attributes() { return [ 'namebody' => '設定名', 'name' => '設定名', ]; } public function messages() { return [ 'namebody.required' => '設定名は必須です。', 'namebody.between' => '設定名は:min文字から:max文字で入力してください。', 'namebody.check_alphanum_under_hyphen' => '設定名には、英数字 - _ のみ使用可能です。', 'namebody.regex' => '設定名の先頭は英数字である必要があります。', 'name.unique' => '設定名が他の設定と重複しています。', 'bookmarks.max_bookmarks' => 'ブックマークは:max件まで登録可能です。', 'id.using' => '使用中のBookmark設定は削除できません。', ]; } public function withValidator($validator) { switch ($this->method()) { case 'DELETE': $validator->after(function ($validator) { if (ManagedBookmark::find($this->id)->isUsed()) { $validator->errors()->add('id', $this->messages()['id.using']); } }); break; } } public function prepareForValidation() { switch ($this->method()) { case 'POST': case 'PUT': if (!empty($this->input('namebody'))) { $this->merge([ 'name' => ManagedBookmark::NAME_PREFIX . strtoupper($this->input('namebody')) ]); } break; } } } 