<?php
 namespace App\Http\Requests; use App\Http\Requests\Request; use App\Organization; use App\Scvgroup; use App\Scvuser; use App\Firefoxprofile; use App\AdminPolicy; use App\ScvxChromeSetting; class OrganizationRequest extends Request { public function authorize() { return true; } public function rules() { $method = $this->method(); $rule = [ 'name' => ['required', 'regex:/^[a-zA-Z0-9]+[a-zA-Z0-9_\.\-]+$/', 'between:3,40'], 'pwd_length' => ['sometimes','integer', 'max:32', 'min:1', 'required'], 'pwd_generation_limit' => ['sometimes','integer', 'max:24'] ]; if ($method === 'POST') $rule['name'][] = 'unique:organizations'; if ($method === 'PUT') { $rule['enable_stz'][] = 'using_option'; $rule['enable_vck'][] = 'using_option'; $rule['enable_tck'][] = 'using_option'; } if ($method === 'POST' || $method === 'PUT') return $rule; return []; } public function messages() { return [ 'name.required' => '組織名が入力されていません。', 'name.unique' => '既に登録された組織名です。', 'name.regex' => '組織名に使用できない文字が含まれています。', 'name.between' => '組織名は3文字から40文字で入力してください。', 'pwd_length.required' => 'パスワードの最低文字数が入力されていません。', 'pwd_length.min' => 'パスワードの最低文字数は最低1文字以上で設定してください。', 'pwd_length.max' => 'パスワードの最低文字数は最大32文字以内で設定してください。', 'pwd_generation_limit.max' => '重複チェックを行う世代数は最大24世代以内で設定してください。', 'enable_stz.using_option' => '無害化を有効化しているグループがあるためオプションの変更ができません。', 'enable_vck.using_option' => 'ウィルスチェックを有効化しているグループがあるためオプションの変更ができません。', 'enable_tck.using_option' => 'サンドボックスチェックを有効化しているグループがあるためオプションの変更ができません。' ]; } public function withValidator($validator) { $validator->after(function ($validator) { $max_term = Request::input('pwd_max_term'); $min_term = Request::input('pwd_min_term'); if ($max_term > 0 && $min_term >= $max_term) { $msg = "パスワード変更の最低間隔は有効期限（{$max_term}日）未満で設定してください。"; $validator->errors()->add('pwd_min_term', $msg); } if (Request::method() === 'DELETE') { $name = Request::input('name'); $organization = Organization::where('name', $name)->first(); if ($organization->name === 'ADMIN') { $msg = "ADMIN組織は削除できません"; $validator->errors()->add('name', $msg); } if (Organization::used_by_user($organization->id)) { $msg = "管理者アカウントに設定されている組織です。"; $validator->errors()->add('name', $msg); } if (count(Scvgroup::listGroupsByOrgId($organization->id)) > 1 && Scvgroup::orgInScvtemplateExists($organization->id)) { if (Organization::used_by_scvgroup($organization->id)) { $msg = "グループに設定されている組織です。"; $validator->errors()->add('name', $msg); } } if (Scvuser::usedByNormalUser($organization->id)) { $msg = "scvtemplateユーザ以外の一般ユーザが残っています。"; $validator->errors()->add('name', $msg); } if (Firefoxprofile::usedByFirefoxprofile($organization->id)) { $msg = "グループに設定されているFirefox設定が残っています。"; $validator->errors()->add('name', $msg); } if (AdminPolicy::existSetting($organization->id)) { $msg = "管理者パスワードポリシーが設定されている組織です。"; $validator->errors()->add('name', $msg); } if (ScvxChromeSetting::usedByChromeprofile($organization->id)) { $msg = "グループに設定されているSCVX Chrome設定が残っています。"; $validator->errors()->add('name', $msg); } } }); } protected function prepareForValidation() { $enable_stz; $enable_vck; $enable_tck; if(empty($this->input('enable_stz'))){ $enable_stz = 0; } else { $enable_stz = $this->input('enable_stz'); } if(empty($this->input('enable_vck'))){ $enable_vck = 0; } else { $enable_vck = $this->input('enable_vck'); } if(empty($this->input('enable_tck'))){ $enable_tck = 0; } else { $enable_tck = $this->input('enable_tck'); } $this->merge([ 'enable_stz' => $enable_stz, 'enable_vck' => $enable_vck, 'enable_tck' => $enable_tck, ]); } } 