<?php
 namespace App\Http\Requests; use Illuminate\Foundation\Http\FormRequest; use Illuminate\Validation\Rule; class ProxySettingRequest extends FormRequest { public function authorize() { return true; } public function rules() { $method = $this->method(); if ($method == "POST" || $method == "PUT") { $rule = [ 'name' => ['required', 'between:9,38', 'regex:/^PROXY_[A-Z0-9]+[A-Z0-9_\.\-]+$/'], 'proxy_host' => ['required_if:proxy_type,1', 'max:255'], 'proxy_port' => ['required_if:proxy_type,1', 'numeric', 'between:0,65535'], 'proxy_exceptions' => ['max:65535'], 'proxy_script_url' => ['required_if:proxy_type,2', 'max:255'] ]; } else if($method == "DELETE") { $rule = ['id' => 'using_proxy_setting']; } $rule['name'][] = Rule::unique('proxy_settings')->ignore($this->route('proxy_setting')); return $rule; } public function messages() { return [ 'name.required' => '設定名を入力してください', 'name.unique' => 'すでに登録された設定名です', 'name.between' => '設定名は3文字から32文字で入力してください', 'name.regex' => '設定名に使用できない文字が含まれています', 'proxy_host.required_if' => 'Proxyホストを入力してください', 'proxy_host.max' => 'Proxyホストは255文字以内で入力してください', 'proxy_port.required_if' => 'Proxyポートを入力してください', 'proxy_port.between' => 'Proxyポートは1から65535までの間で入力してください', 'proxy_exceptions.max' => 'Proxy例外は65535文字以内で入力してください', 'proxy_script_url.required_if' => 'ProxyスクリプトURLを入力してください', 'proxy_script_url.max' => 'ProxyスクリプトURLは255文字以内で入力してください', 'id.using_proxy_setting' => '利用中の設定のため削除できません', ]; } protected function validationData() { if($this->method() == "DELETE"){ $data = $this->all(); if (isset($this->id)) { $data['id'] = $this->id; } return $data; }else{ return $this->all(); } } protected function prepareForValidation() { $pt = $this->input('proxy_type'); $this->merge([ 'id' => $this->id ?: $this->route('proxy_setting'), 'name' => 'PROXY_'.strtoupper($this->input('name')), 'proxy_host' => $pt == 1 ? $this->input('proxy_host') : "", 'proxy_port' => $pt == 1 ? $this->input('proxy_port') : 0, 'proxy_exceptions' => $pt == 1 ? $this->input('proxy_exceptions') : "", 'proxy_script_url' => $pt == 2 ? $this->input('proxy_script_url') : "" ]); } } 