<?php
 namespace App\Http\Requests; use App\Http\Requests\Request; use App\Libs\ADHelper as ADH; use App\Scvuser; class ScvuserRequest extends Request { public function authorize() { return true; } public function rules() { $lmode = ADH::isScvxLdap(); $kmode = ADH::isScvxKerberos(); $method = $this->method(); if($method == "POST"){ if(!$kmode && !$lmode){ return [ 'name' => ['required', 'unique_user_in_org','between:4,32','regex:/^[a-z0-9]+[a-z0-9_.-]+$/','disable_str'], 'post' => ['max:64'], 'password' => ['required', 'confirmed', 'between:4,32', 'pass_rule'] ]; }else{ return [ 'name' => ['required', 'unique:scvusers','between:4,32','regex:/^[a-z0-9]+[a-z0-9_.-]+$/','disable_str'], 'post' => ['max:64'] ]; } }elseif($method == "PUT"){ return [ 'name' => ['required', 'unique_user_in_org','between:4,32','regex:/^[a-z0-9]+[a-z0-9_.-]+$/','disable_str'] ]; }elseif($method == "DELETE"){ $user = Scvuser::find($this->id); return [ 'name' => ['disable_del'], 'id' => ['running_user'] ]; }else{ return[]; } } public function messages() { return [ 'name.required' => 'ユーザ名は必須項目です。', 'name.unique_user_in_org'=> 'ユーザ名は組織内で重複できません。', 'name.unique' => '既に登録されたユーザ名です。', 'name.between' => 'ユーザ名は4文字から32文字で入力してください。', 'name.regex' => 'ユーザ名に使用できない文字列です。', 'name.disable_str' => '使用できないユーザ名です。', 'name.disable_del' => '削除できないユーザです。', 'id.running_user' => 'コンテナ起動中のユーザは削除できません。', 'jpname.required' => '氏名は必須項目です。', 'jpname.max' => '氏名は1文字から32文字で入力してください。', 'department.required' => '部署は必須項目です。', 'department.max' => '部署は最大64文字で入力してください。', 'post.required' => '役職は必須項目です。', 'post.max' => '役職は最大64文字で入力してください。', 'password.required' => 'パスワードが空です。', 'password.confirmed' => 'パスワードが一致しません。', 'password.between' => 'パスワードは4文字から32文字で入力してください。', 'password.pass_rule' => 'パスワードに使用できない文字が含まれています。' ]; } } 