<?php
 namespace App\Http\Requests; use Illuminate\Foundation\Http\FormRequest; use Illuminate\Validation\Rule; class ScvxChromeSettingRequest extends FormRequest { public function authorize() { return true; } public function rules() { $method = $this->method(); if ($method == "POST" || $method == "PUT") { $rule = [ 'name' => ['required', 'between:10,39', 'regex:/^[A-Za-z0-9]+[A-Za-z0-9_\.\-]+$/' ], 'homepage' => ['max:255'], 'startup_page' => ['max:255', 'compare_maxtab'], 'bookmark_toplevel' => ['max:255' ], 'bookmarks' => ['max_bookmarks', 'max_bookmarks_size'], 'enable_pauth' => ['need_enable_pauth'], 'pauth_user' => ['max:255','required_if:pauth_account,1'], 'pauth_pass' => ['max:96','required_if:pauth_account,1'], ]; if ($method == "POST") { $rule['name'][] = Rule::unique('scvx_chrome_settings')->where(function($query){ $query->where('organization_id', $this->input('organization_id')); }); } else if ($method == "PUT") { $rule['name'][] = Rule::unique('scvx_chrome_settings')->ignore($this->id)->where(function($query){ $query->where('organization_id', $this->input('organization_id')); }); $rule['id'] = ['using_chrome_other_org']; } return $rule; } else if($method == "DELETE") { return [ 'id' => 'using_scvx_chrome_setting', ]; } else { return []; } } public function messages() { return [ 'name.required' => '設定名を入力してください', 'name.unique' => 'すでに登録された設定名です', 'name.between' => '設定名は3文字から32文字で入力してください', 'name.regex' => '設定名に使用できない文字が含まれています', 'homepage.max' => 'ホームページは255文字以内で入力してください', 'startup_page.max' => 'スタートページは255文字以内で入力してください', 'startup_page.compare_maxtab' => 'スタートページの個数は最大タブ数以下で入力してください。', 'id.using_scvx_chrome_setting' => '利用中の設定のため削除できません', 'id.using_chrome_other_org' => '使用中のプロファイルのため、組織の変更ができません。', 'bookmark_toplevel.max' => 'Bookmarkトップフォルダ名は255文字以内で入力してください', 'bookmarks.max_bookmarks' => 'ブックマークは100件まで登録可能です。', 'bookmarks.max_bookmarks_size' => 'ブックマークの入力可能文字数を超えました。', 'enable_pauth.need_enable_pauth' => 'Proxy-Authorizationを有効化してください。', 'pauth_user.max' => 'Proxy-Authorizationのユーザ名は255文字以内で入力してください。', 'pauth_pass.max' => 'Proxy-Authorizationのパスワードは255文字以内で入力してください。', 'pauth_user.required_if' => 'Proxy-Authorizationのユーザ名を入力してください。', 'pauth_pass.required_if' => 'Proxy-Authorizationのパスワードを入力してください。', ]; } protected function validationData() { if($this->method() == "DELETE"){ $data = $this->all(); if (isset($this->id)) { $data['id'] = $this->id; } return $data; }else{ return $this->all(); } } protected function prepareForValidation() { $this->merge([ 'name' => 'CHROME_'.strtoupper($this->input('name')), 'pauth_account' => $this->input('pauth_account') != null ? 1 : 0, 'pauth_user' => $this->input('pauth_account') != null ? $this->input('pauth_user') : "", 'pauth_pass' => $this->input('pauth_account') != null ? $this->input('pauth_pass') : "", ]); } } 