<?php
 namespace App\Http\Requests; use App\Http\Requests\Request; use App\Organization; use Illuminate\Validation\Rule; class ShareRequest extends Request { public function authorize() { return true; } public function rules() { $method = $this->method(); if($method == "POST" || $method == "PUT"){ $rule = [ 'shname' => ['required', 'regex:/^[A-Za-z0-9]+[A-Za-z0-9_\.\-]+$/', 'between:9,38'], 'sharename1' => ['check_share'], 'sharename2' => ['check_share'], 'sharedom1' => ['check_dom'], 'sharedom2' => ['check_dom'], 'shareusr1' => ['required_with:use_scvuser1'], 'sharepwd1' => ['required_with:use_scvuser1'], 'shareusr2' => ['required_with:use_scvuser2'], 'sharepwd2' => ['required_with:use_scvuser2'], ]; if ($method == "POST") { $rule['shname'][] = Rule::unique('shareprofiles')->where(function($query){ $query->where('organization_id', $this->input('organization_id')); }); } else if ($method == "PUT") { $rule['shname'][] = Rule::unique('shareprofiles')->ignore($this->id)->where(function($query){ $query->where('organization_id', $this->input('organization_id')); }); } return $rule; } else if($method == "DELETE") { return [ 'id' => [ 'using_share_prof'] ]; } } public function messages() { return [ 'id.using_share_prof' => '使用中のプロファイルです。', 'shname.required' => '共有フォルダ設定名は必須項目です。', 'shname.between' => '共有フォルダ設定名は3文字から32文字で入力してください。', 'shname.regex' => '共有フォルダ設定名に使用できない文字が含まれています。', 'shname.unique' => '既に登録された設定名です。', 'unique_share_update' => 'すでに登録された設定名です。', 'check_share' => '共有は//server/shareの形式で入力してください。', 'check_dom' => 'ドメイン名は英数と.のみ使用可能です。', 'shareusr1.required_with' => 'ユーザ名を入力して下さい。', 'sharepwd1.required_with' => 'パスワードを入力して下さい。', 'shareusr2.required_with' => 'ユーザ名を入力して下さい。', 'sharepwd2.required_with' => 'パスワードを入力して下さい。' ]; } protected function validationData() { if($this->method() == "DELETE"){ $data = $this->all(); if (isset($this->share)) { $data['id'] = $this->share; } return $data; }else{ return $this->all(); } } protected function prepareForValidation() { $this->merge([ 'shname' => 'SHARE_'.strtoupper($this->input('shname')), ]); } } 