<?php
namespace App\Http\Requests; use App\Http\Requests\Request; use Illuminate\Validation\Rule; class UserRequest extends Request { public function authorize() { return true; } public function rules() { $method = $this->method(); if($method == "POST"){ return [ 'username' => ['required', 'unique:users', 'regex:/^[a-zA-Z0-9]+[a-zA-Z0-9_\.\-]+$/', 'between:4,32'], 'email' => ['required', 'unique:users'], 'password' => ['required', 'confirmed', 'pass_rule'] ]; }else if($method == "PATCH"){ return [ 'email' => ['required', Rule::unique('users')->ignore($this->user_id)], 'password' => ['confirmed', 'pass_rule'] ]; }else if($method == "DELETE"){ return [ 'username' => ['check_admin'] ]; }else{ return []; } } public function messages() { return [ 'username.required' => 'ユーザ名が入力されていません。', 'username.unique' => '既に登録されたユーザ名です。', 'username.regex' => 'ユーザ名に使用できない文字が含まれています。', 'username.between' => 'ユーザ名は4文字から32文字で入力してください。', 'email.required' => 'メールアドレスが入力されていません。', 'email.unique' => '既に登録されたメールアドレスです。', 'password.required' => 'パスワードが入力されていません。', 'password.confirmed' => 'パスワードが一致しません。', 'password.pass_rule' => 'パスワードに使用できない文字が含まれています。', 'username.check_admin' => 'adminは削除できません。' ]; } } 