<?php
 namespace App\Http\Requests; use Illuminate\Foundation\Http\FormRequest; use Illuminate\Validation\Rule; class VpnSettingRequest extends FormRequest { public function authorize() { return true; } public function rules() { $method = $this->method(); if ($method == "POST" || $method == "PUT") { $rule = [ 'name' => [ 'required', 'between:7,36', 'regex:/^[A-Za-z0-9]+[A-Za-z0-9_\.\-]+$/' ], 'local_address' => [ 'required_without:global_address', 'ipv4' ], 'global_address' => [ 'ipv4_and_port' ], 'interface_name' => [ 'required', 'max:255' ], 'dns_servers' => [ 'ipv4' ], 'allowed_hosts' => [ 'required', 'allowed_hosts', 'max:65535' ] ]; if ($method == "POST") { $rule['name'][] = Rule::unique('vpn_settings'); } else if ($method == "PUT") { $rule['name'][] = Rule::unique('vpn_settings')->ignore($this->route('vpn_setting')); } return $rule; } else if ($method == "DELETE") { return [ 'id' => ['used_vpn_setting'] ]; } else { return []; } } public function messages() { return [ 'name.required' => '設定名を入力してください', 'name.unique' => 'すでに登録された設定名です', 'name.between' => '設定名は3文字から32文字で入力してください', 'name.regex' => '設定名に使用できない文字が含まれています', 'local_address.required_without' => 'VPNサーバアドレス(ローカル)またはVPNサーバアドレス(グローバル)を入力してください', 'local_address.ipv4' => 'VPNサーバアドレス(ローカル)はIPv4の形式で入力してください', 'global_address.ipv4_and_port' => 'VPNサーバアドレス(グローバル)はIPアドレス:ポート番号の形式で入力してください', 'interface_name.required' => 'VPNインターフェースを入力してください', 'interface_name.max' => 'VPNインターフェース名は255文字以内で入力してください', 'dns_servers.ipv4' => 'DNSサーバアドレスはIPv4形式で入力してください。', 'allowed_hosts.required' => '許可ホストを入力してください', 'allowed_hosts.allowed_hosts' => '許可ホストはIPv4もしくは、CIDR形式で入力してください', 'allowed_hosts.max' => '許可ホストは65535文字以内で入力してください', 'id.used_vpn_setting' => '利用中の設定のため削除できません' ]; } protected function validationData() { if($this->method() == "DELETE"){ $data = $this->all(); if (isset($this->id)) { $data['id'] = $this->id; } return $data; }else{ $data = $this->all(); if (isset($data['allowed_hosts'])) { $data['allowed_hosts'] = preg_replace("/\r\n/", "\n", $data['allowed_hosts']); } return $data; } } protected function prepareForValidation() { $this->merge([ 'name' => 'VPN_'.strtoupper($this->input('name')) ]); } } 