<?php
declare(strict_types = 1); namespace App\Http\Requests; use App\Models\Wallpaper; use App\Visionprofile; use Illuminate\Foundation\Http\FormRequest; class WallpaperRequest extends FormRequest { public function authorize() { return true; } public function rules() { $rules = []; $method = $this->method(); switch ($method) { case 'POST': $rules = [ 'wallpaper' => [ 'required', 'max:10240', ], 'filename' => [ 'max:255', ], 'mimetype' => [ 'in:' . implode(',', Wallpaper::ACCEPTABLE_MIME_TYPES), ], ]; break; } return $rules; } public function messages() { return [ 'wallpaper.required' => 'ファイルがアップロードされていません。', 'wallpaper.max' => 'ファイルサイズが10MBを超えています。', 'filename.max' => 'ファイル名が255文字を超えています。', 'mimetype.in' => 'このファイル形式には対応していません。', 'wallpaper.usedbydt' => 'デスクトップ設定で使用中の壁紙は削除できません。', ]; } public function withValidator($validator) { switch ($this->method()) { case 'DELETE': $validator->after(function ($validator) { if (Visionprofile::isWallpaperUsed($this->id)) { $validator->errors()->add('wallpaper', $this->messages()['wallpaper.usedbydt']); } }); break; } } public function prepareForValidation() { switch ($this->method()) { case 'POST': $file = $this->file('wallpaper'); if (is_null($file) || !$file->isValid()) { return; } $this->merge([ 'filename' => $file->getClientOriginalName(), 'mimetype' => mime_content_type($file->getRealPath()), ]); break; case 'DELETE': $this->merge([ 'id' => $this->id ?: intval($this->route('wallpaper')), ]); break; } } } 