<?php
 namespace App\Http\Requests\revobr; use Illuminate\Foundation\Http\FormRequest; use Illuminate\Contracts\Validation\Validator; use Illuminate\Http\Exceptions\HttpResponseException; use App\Scvuser; use App\Clientlog; class GAuthRequest extends FormRequest { public function authorize() { return true; } public function getEscapeParams() { $params = $this->input(); $params["password"] = escapeshellarg($params["password"]); $params["ip"] = escapeshellarg($params["ip"]); $params["org_user"] = escapeshellarg($params["organization"].'/'.$params["user"]); return $params; } public function getScvuser() { $params = $this->input(); return Scvuser::with_org($params['organization'], $params['user']); } public function rules() { $method = $this->method(); if($this->is('*/status')){ return [ 'organization' => 'required', 'user' => 'required', 'password' => 'required', 'ip' => 'required' ]; }else if($this->is('*/qr')){ return [ 'organization' => 'required', 'user' => 'required|user_in_org|gauth_initialized', 'password' => 'required' ]; }else if($this->is('*/gauth')){ return [ 'organization' => 'required', 'user' => 'required|user_in_org|locked', 'password' => 'required' ]; }else{ return []; } } public function messages() { return [ 'user.locked' => 'This account has been locked.', '*' => 'Bad Request' ]; } protected function failedValidation(Validator $validator) { $res = response()->json([ 'status' => 'error', 'message' => $validator->errors()->first(), ], 400); logger($validator->errors()); Clientlog::insertLog(Clientlog::MSG_LOGIN_FAILURE, $this, null); throw new HttpResponseException($res); } } 