<?php
 namespace App\Http\Requests\revobr; use Illuminate\Foundation\Http\FormRequest; use App\revobr\BrUpdatePolicy as BUP; class UpdatePolicyRequest extends FormRequest { public function authorize() { return true; } public function rules() { $rules = [ 'name' => 'required|between:1,255', 'update_from' => 'required|between:1,255', 'scheduled_interval' => 'numeric|between:0,365', 'scheduled_weekly' => 'numeric|between:0,7', 'scheduled_monthly' => 'numeric|between:1,31', 'scheduled_start_time' => 'date_format:H:i', 'scheduled_time_period' => 'numeric|between:0,24', 'target_application' => 'required|array', ]; if($this->match_type == BUP::MATCH_TYPE_IPV4){ $rules['match_value'] = 'required|cidr'; } if($this->match_type == BUP::MATCH_TYPE_HOSTNAME){ $rules['match_value'] = 'required'; } if($this->match_type == BUP::MATCH_TYPE_SCVGROUP){ $rules['match_value'] = 'required|exists_group'; } return $rules; } public function messages() { return [ 'name.required' => 'ポリシー名は必須項目です。', 'name.between' => 'ポリシー名は255文字以下で入力してください。', 'update_from.required' => 'アップデートサーバは必須項目です。', 'update_from.between' => 'アップデートサーバは255文字以下で入力してください。', 'scheduled_interval.between' => '日は0から365の間で指定してください。', 'scheduled_time_period.between' => '時間枠は0から24の間で指定してください。', 'match_value.cidr' => 'IPアドレスはCIDR表記で指定してください。', 'match_value.required' => 'マッチタイプの値は必須項目です。', 'match_value.exists_group' => '存在しないグループです。', 'target_application.required' => '対象アプリケーションは必須項目です。', ]; } public function convert() { $p = $this->input(); if($p['type'] == BUP::POLICY_TYPE_DAY){ $p['scheduled_interval'] = 0; $p['scheduled_weekly'] = 0; $p['scheduled_monthly'] = 0; }else if($p['type'] == BUP::POLICY_TYPE_INTERVAL){ $p['scheduled_day'] = 0; $p['scheduled_weekly'] = 0; $p['scheduled_monthly'] = 0; }else if($p['type'] == BUP::POLICY_TYPE_WEEKLY){ $p['scheduled_interval'] = 0; $p['scheduled_day'] = 0; $p['scheduled_monthly'] = 0; }else if($p['type'] == BUP::POLICY_TYPE_MONTHLY){ $p['scheduled_interval'] = 0; $p['scheduled_weekly'] = 0; $p['scheduled_day'] = 0; } if(!isset($p['hide_update_menu'])){ $p += array('hide_update_menu' => 0); } if(!isset($p['target_application'])){ $p += array('target_application' => 0); } if(isset($p['match_type']) && $p['match_type'] == BUP::MATCH_TYPE_SCVGROUP){ $p['match_value'] = strtoupper($p['match_value']); } unset($p['_token']); unset($p['type']); return $p; } } 