<?php
 namespace App\Jobs; use Illuminate\Bus\Queueable; use Illuminate\Queue\SerializesModels; use Illuminate\Queue\InteractsWithQueue; use Illuminate\Contracts\Queue\ShouldQueue; use Illuminate\Foundation\Bus\Dispatchable; use Illuminate\Validation\ValidationException; use App\Organization; use App\Scvgroup; use App\Scvuser; use App\Libs\ClusterHelper as CH; use App\Models\LdapSetting; class ScvgroupJob implements ShouldQueue { use Dispatchable, InteractsWithQueue, Queueable, SerializesModels; private $data; private $act; private $dont_throw; private $cluster; public function __construct($act, $params, $dont_throw = false) { $this->act = $act; $this->data = $params; $this->dont_throw = $dont_throw; $this->cluster = CH::isCluster(); } public function handle() { $validator = \Validator::make($this->data, $this->rules(), $this->messages()); $self = $this; $validator->after(function($validator) use($self) { $id = isset($self->data['id']) ? $self->data['id'] : null; $org_id = $self->data['organization_id']; $organization = Organization::find($org_id); if ($organization === null) { $validator->errors()->add('name', '組織が存在しません。'); return; } $org = $organization->name; $name = $self->data['name']; if ($self->act === 'store') { if (Scvgroup::with_org($org, $name)) $validator->errors()->add('name', '既に登録されたグループ名です。'); } if ($self->act === 'update') { if ($id === null) { if (Scvgroup::with_org($org, $name) === null) $validator->errors()->add('name', '組織にグループが存在しません。'); } elseif (Scvgroup::find($id)->name !== $name) { if (Scvgroup::with_org($org, $name)) $validator->errors()->add('name', '既に登録されたグループ名です。'); } } if ($this->act === 'store' || $this->act === 'update') { $sanitize = $this->data['sanitize']; if ($sanitize & LIC_STZ_SCVX && !$organization->enable_stz) { $validator->errors()->add('stz_flag', '無害化オプションは禁止されています。'); } if ($sanitize & LIC_VCK && !$organization->enable_vck) { $validator->errors()->add('vck_flag', 'ウィルスチェックオプションは禁止されています。'); } if ($sanitize & LIC_TCK && !$organization->enable_tck) { $validator->errors()->add('tck_flag', 'サンドボックスオプションオプションは禁止されています。'); } } if ($self->act === 'destroy') { $scvgroup = Scvgroup::with_org($org, $name); if (strtolower($name) == "admin" || strtolower($name) == 'default') $validator->errors()->add('name', 'このグループは削除できません。'); elseif ($scvgroup === null) $validator->errors()->add('name', '組織にグループが存在しません。'); elseif (Scvuser::where('groupid', $scvgroup->id)->exists() || LdapSetting::isGroupUsed($scvgroup->id)) $validator->errors()->add('name', 'このグループは使用されているため削除できません。'); } }); if ($validator->fails()) { if ($this->dont_throw) { $msgs = $validator->errors()->all(); return $msgs ? $msgs[0] : ''; } else { throw new ValidationException($validator); } } if ($this->act === 'store') $this->store(); else if ($this->act === 'update') $this->update(); else if ($this->act === 'destroy') $this->destroy(); else throw new \Exception('存在しないアクションが指定されました。'); return ''; } public function rules() { if ($this->act === 'destroy') return []; return [ 'name' => ['required', 'between:3,32', 'regex:/^[A-Za-z0-9]+[A-Za-z0-9_\.\-]+$/', 'disable_gstr'], 'hour' => ['hour_vali'], 'offline_expiration' => ['numeric','between:0,240'] ]; } public function messages() { return [ 'name.required' => 'グループ名は必須項目です。', 'name.unique' => '既に登録されたグループ名です。', 'name.between' => 'グループ名は3文字から32文字で入力してください。', 'name.regex' => 'グループ名に使用できない文字が含まれています。', 'name.disable_gstr' => '禁止された文字列です。', 'hour.hour_vali' => '00:00-24:00の間で入力してください。', 'offline_expiration.between'=> 'オフライン起動有効期限は0-240の範囲で入力してください。' ]; } public function store() { $prms = $this->data; $scvgroup = new Scvgroup; $fields = Scvgroup::get_fields(['id']); foreach ($fields as $field) { if (isset($prms[$field])) $scvgroup->$field = $prms[$field]; } $dbret = $scvgroup->save(); $slave_dbret = 0; if (CH::needsToSyncSlave()) $slave_dbret = CH::saveScvgroupToSlaveDB($scvgroup); $this->update_clusters_if_necessary($dbret, $slave_dbret); } public function update() { $prms = $this->data; $org_id = $prms['organization_id']; $name = $prms['name']; if (isset($prms['id'])) $scvgroup = Scvgroup::find($prms['id']); else $scvgroup = Scvgroup::where('organization_id', $org_id)->where('name', $name)->first(); $fields = Scvgroup::get_fields(['id']); foreach ($fields as $field) { if (isset($prms[$field])) $scvgroup->$field = $prms[$field]; } $dbret = $scvgroup->save(); $slave_dbret = 0; if (CH::needsToSyncSlave()) $slave_dbret = CH::updateScvgroupToSlaveDB($scvgroup); $this->update_clusters_if_necessary($dbret, $slave_dbret); } public function destroy() { $prms = $this->data; $org_id = $prms['organization_id']; $name = $prms['name']; $scvgroup = Scvgroup::where('organization_id', $org_id)->where('name', $name)->first(); $id = $scvgroup->id; $dbret = $scvgroup->delete(); $slave_dbret = 0; if (CH::needsToSyncSlave()) $slave_dbret = CH::deleteScvgroupToSlaveDB($id); $this->update_clusters_if_necessary($dbret, $slave_dbret); } private function update_clusters_if_necessary($dbret, $slave_dbret) { if (!$this->cluster) return; if (CH::isMaster() && CH::isSlaveAlive() && CH::isSlaveActive()) { CH::updateClusters($dbret, $slave_dbret); } else if (CH::isMaster()) { CH::updateClusters($dbret, false); } else if (CH::isSlave()) { CH::updateClusters(false, $dbret); } else { throw new \Exception('MemberサーバでDBを変更しようとしました'); } } } 