<?php
 namespace App\Jobs; use Illuminate\Bus\Queueable; use Illuminate\Queue\SerializesModels; use Illuminate\Queue\InteractsWithQueue; use Illuminate\Contracts\Queue\ShouldQueue; use Illuminate\Foundation\Bus\Dispatchable; use Illuminate\Validation\ValidationException; use DB; use App\Scvgroup; use App\Scvuser; use App\Libs\ClusterHelper as CH; use App\Libs\ADHelper as ADH; use App\Libs\ConfHelper; use App\Libs\PasswordUpdator; class ScvuserJob implements ShouldQueue { use Dispatchable, InteractsWithQueue, Queueable, SerializesModels; private $data; private $act; private $dont_throw; private $dont_job; private $login_user; private $cluster; private $using_password; private $not_forms = [ 'id', 'password', 'pwd_reset_at', 'pwd_generations', 'gauth_key', 'gauth_used', 'otpwd', 'groupid', 'firefoxprofile_id', 'remember_token', 'created_at', 'updated_at', 'scvtimemill' ]; public function __construct($act, $params, $dont_throw = false, $login_user = null, $dont_job = false) { $this->act = $act; $this->data = $this->init_params($params); $this->dont_throw = $dont_throw; $this->dont_job = $dont_job; $this->login_user = $login_user; $this->cluster = CH::isCluster(); $this->using_password = ConfHelper::usingPassword(); } private function init_params($params) { $initial_empty = [ 'organization', 'password', 'password_confirmation', 'group', 'name', 'email', 'comment', 'employee_id', 'jpname', 'department', 'post', 'custom_data1', 'custom_data2', 'custom_data3', 'flow_group' ]; $initial_zero = [ 'privilege' ]; foreach ($initial_empty as $key) { if (!isset($params[$key]) || is_null($params[$key])) $params[$key] = ''; } foreach ($initial_zero as $key) { if (!isset($params[$key]) || is_null($params[$key])) $params[$key] = 0; } return $params; } public function handle() { $rules = $this->rules(); $login_user = $this->login_user; if ($login_user && $login_user->organization_id !== 1) $rules['group'][] = 'group_in_org'; $validator = \Validator::make($this->data, $rules, $this->messages()); $self = $this; $validator->after(function($validator) use($self) { $using_password = $self->using_password; $act = $self->act; $password = $self->data['password']; $password_confirmation = $self->data['password_confirmation']; $org = $self->data['organization']; $user = $self->data['name']; if ($act !== 'store' && $act !== 'update') return; if (!$using_password && $password === '') { return; } $isPasswordRequired = $using_password || $user === 'scvtemplate'; if (!$isPasswordRequired && $password !== '') { $validator->errors()->add('password', '現在の認証方式でパスワードを設定することはできません。'); return; } if ($act === 'update' && $password === '') return; try { if ($act === 'store' && $user !== 'scvtemplate') PasswordUpdator::validate_registerable($org, $user, $password, $password_confirmation); else if ($act === 'update') PasswordUpdator::validate_changeable($org, $user, $password, $password_confirmation); } catch (ValidationException $e) { $eachmsgs = $e->validator->messages()->messages(); foreach ($eachmsgs as $field => $errmsgs) foreach ($errmsgs as $errmsg) $validator->errors()->add($field, $errmsg); } }); if ($validator->fails()) { if ($this->dont_throw) { $msgs = $validator->errors()->all(); if ($msgs) return $msgs[0]; else return ''; } else { throw new ValidationException($validator); } } if ($this->dont_job) return ''; if ($this->act === 'store') $this->store(); else if ($this->act === 'update') $this->update(); else if ($this->act === 'destroy') $this->destroy(); else throw new \Exception('存在しないアクションが指定されました。'); return ''; } public function rules() { $rules = [ 'organization' => ['required', 'exists:organizations,name'], 'group' => ['required'], 'name' => [ 'required', 'between:2,32', 'regex:/^[a-z0-9]+[a-z0-9_.-]+$/' ], 'employee_id' => ['max:255', 'flow_str'], 'jpname' => ['max:255', 'flow_str'], 'department' => ['max:255', 'flow_str'], 'post' => ['max:255', 'flow_str'], 'custom_data1' => ['max:255', 'flow_str'], 'custom_data2' => ['max:255', 'flow_str'], 'custom_data3' => ['max:255', 'flow_str'], 'flow_group' => ['max:255'] ]; if ($this->act === 'store') { $rules['name'][] = 'disable_str'; $rules['name'][] = 'no_user_in_org'; } if ($this->act === 'store' || $this->act === 'update') { if ((int)ConfHelper::scvconf('SCV_FLOW') && $this->data['name'] !== 'scvtemplate') $rules['email'] = ['required', 'between:4,255', 'email']; else $rules['email'] = ['between:4,255', 'email']; } if ($this->act === 'update' || $this->act === 'destroy') { $rules['name'][] = 'user_in_org'; } if ($this->act === 'destroy') { $rules['name'][] = 'running_user'; $rules['name'][] = 'disable_del'; } return $rules; } public function messages() { return [ 'organization.required' => '組織名は必須項目です。', 'organization.exists:organizations,name' => '組織が存在しません。', 'group.required' => 'グループ名は必須項目です。', 'group.group_in_org' => '組織内にグループが存在しません。', 'name.required' => 'ユーザ名は必須項目です。', 'name.user_in_org' => '組織内にユーザが存在しません。', 'name.user_in_group' => 'グループ内にユーザが存在しません。', 'name.no_user_in_org' => '組織内に既に存在するユーザ名です。', 'name.between' => 'ユーザ名は2文字から32文字で入力してください。', 'name.regex' => 'ユーザ名に使用できない文字列です。', 'name.disable_str' => '使用できないユーザ名です。', 'name.disable_del' => '削除できないユーザです。', 'name.running_user' => 'コンテナ起動中のユーザは削除できません。', 'email.required' => 'メールアドレスは必須項目です。', 'email.between' => 'メールアドレスは4文字から255文字で入力してください。', 'email.email' => 'メールアドレスの書式が間違っています。', 'employee_id.max' => '社員番号は255文字以内で入力してください。', 'employee_id.flow_str' => '社員番号に使用できない文字が含まれています。', 'jpname.max' => '氏名は255文字以内で入力してください。', 'jpname.flow_str' => '氏名に使用できない文字が含まれています。', 'department.max' => '部署は255文字以内で入力してください。', 'department.flow_str' => '部署に使用できない文字が含まれています。', 'post.max' => '役職は255文字以内で入力してください。', 'post.flow_str' => '役職に使用できない文字が含まれています。', 'custom_data1.max' => '任意データ1は255文字以内で入力してください。', 'custom_data1.flow_str' => '任意データ1に使用できない文字が含まれています。', 'custom_data2.max' => '任意データ2は255文字以内で入力してください。', 'custom_data2.flow_str' => '任意データ2に使用できない文字が含まれています。', 'custom_data3.max' => '任意データ3は255文字以内で入力してください。', 'custom_data3.flow_str' => '任意データ3に使用できない文字が含まれています。', 'flow_group.max' => 'SCVFlowの承認グループは255文字以内で入力してください。', ]; } public function store() { $scvuser = new Scvuser; $this->assign_form_params($scvuser); $scvuser->groupid = $this->get_group_id(); $scvuser->firefoxprofile_id = 0; $scvuser->gauth_used = 0; $scvuser->gauth_key = ''; $scvuser->otpwd = ''; $scvuser->pwd_generations = ''; $scvuser->pwd_reset_at = date('Y-m-d H:i:s'); $scvuser->scvtimemill = CH::getTimemill(); if (!$scvuser->save()) return redirect()->back()->withErrors('データベースへの書き込みに失敗しました'); $slave_dbret = 0; if (CH::needsToSyncSlave()) $slave_dbret = CH::saveScvuserToSlaveDB($scvuser); CH::update_clusters_if_necessary(true, $slave_dbret); $name = $scvuser->name; $cmd = "scvuseradd -s '$name' '{$scvuser->id}'"; shell_exec($cmd); if (CH::needsToSyncSlave()) CH::slave_shell_exec($cmd); if ($this->using_password || $name === 'scvtemplate') { if (!PasswordUpdator::change_password($scvuser, $this->data['password'], $errmsg)) return redirect()->back()->withErrors($errmsg); } } public function update() { $params = $this->data; $scvuser = Scvuser::with_org($params['organization'], $params['name']); $this->assign_form_params($scvuser); $scvuser->groupid = $this->get_group_id(); $scvuser->scvtimemill = CH::getTimemill(); if (!$scvuser->save()) return redirect()->back()->withErrors('データベースへの書き込みに失敗しました'); $password = $params['password']; if ($this->using_password && $password !== '') { $dbret = PasswordUpdator::change_password($scvuser, $password, $errmsg); if (!$dbret) return redirect()->back()->withErrors($errmsg); } $slave_dbret = 0; if (CH::needsToSyncSlave()) $slave_dbret = CH::updateScvuserToSlaveDB($scvuser); CH::update_clusters_if_necessary(true, $slave_dbret); } public function destroy() { $org = $this->data['organization']; $name = $this->data['name']; $scvuser = Scvuser::with_org($org, $name); $id = $scvuser->id; if (CH::isCluster()) { $host = CH::getSlaveHost(); $cmd = "sudo -i -u scvrun ssh scvrun@$host"; $milli_time = floor(microtime(true) * 1000); $dbret = 0; $slave_dbret = 0; $dir_name = floor($id / 10000); $dbret = Scvuser::destroy($id); logger("delete:$dbret id=$id (auth:scvx)"); exec("sudo rm -rf /home/scvrun/.scvusers/$dir_name/$id"); logger("sudo rm -rf /home/scvrun/.scvusers/$dir_name/$id"); if(CH::needsToSyncSlave()){ exec("$cmd \"sudo rm -rf /home/scvrun/.scvusers/$dir_name/$id\""); logger("$cmd \"sudo rm -rf /home/scvrun/.scvusers/$dir_name/$id\""); $slave_dbret = DB::connection('slave_database')->table('scvusers')->where('id', '=', $id)->sharedLock()->delete(); } CH::update_clusters_if_necessary($dbret, $slave_dbret); }else{ $dbret = Scvuser::destroy($id); logger("delete:$dbret id=$id (auth:scvx)"); $dir_name = floor($id / 10000); exec("sudo rm -rf /home/scvrun/.scvusers/$dir_name/$id"); logger("sudo rm -rf /home/scvrun/.scvusers/$dir_name/$id"); } } private function assign_form_params(&$scvuser) { $fields = Scvuser::get_fields($this->not_forms); foreach ($fields as $field) { if (isset($this->data[$field])) $scvuser->$field = $this->data[$field]; } $scvuser->name = mb_strtolower($scvuser->name); } private function get_group_id() { if (isset($this->data['new_organization'])) $group_org = $this->data['new_organization']; else $group_org = $this->data['organization']; $group_name = $this->data['group']; $group_id = Scvgroup::with_org($group_org, $group_name)->id; return $group_id; } } 