<?php
 namespace App\Jobs; use Illuminate\Bus\Queueable; use Illuminate\Queue\SerializesModels; use Illuminate\Queue\InteractsWithQueue; use Illuminate\Contracts\Queue\ShouldQueue; use Illuminate\Foundation\Bus\Dispatchable; use Mail; use App\Scvflow; use App\Scvuser; use App\FlowAuthorizer; use App\Libs\FlowMailSubjectCustomizer; const IDX_FLOW_APPLICANT_REQ_SUBJECT = 0; const IDX_FLOW_AUTHORIZER_REQ_SUBJECT = 1; const IDX_FLOW_APPLICANT_AUTH_SUBJECT = 2; const IDX_FLOW_DOWNLOAD_AUTH_SUBJECT = 3; class SendReminderEmail implements ShouldQueue { use Dispatchable, InteractsWithQueue, Queueable, SerializesModels; private $debug; private $smtp_from; private $smtp_from_name; private $act; private $action_type; private $dl_key; private $host_url; private $latests; public function __construct($act, $action_type, $dl_key, $host_url, $status = 'waiting', $filename = null, $why_denied = null, $authorized_at = null, $authorizer_id = null) { $this->debug = env('APP_DEBUG'); $this->smtp_from = env('MAIL_FROM_ADDRESS', 'notice@nomail.com'); $this->smtp_from_name = env('MAIL_FROM_NAME', 'SCV Flow'); $this->act = $act; $this->action_type = $action_type; $this->dl_key = $dl_key; $this->host_url = $host_url; $this->latests = compact('status', 'filename', 'why_denied', 'authorized_at', 'authorizer_id'); if ($this->latests['filename'] === null) unset($this->latests['filename']); if ($this->latests['why_denied'] === null) unset($this->latests['why_denied']); if ($this->latests['authorized_at'] === null) unset($this->latests['authorized_at']); if ($this->latests['authorizer_id'] === null) unset($this->latests['authorizer_id']); } public function handle() { try { $scvflow = $this->bind_latest_field($this->dl_key); $data = $this->make_view_data($scvflow, $this->host_url); if ($this->debug) $this->log_before_sending($scvflow); $act = $this->act; $this->$act($scvflow, $data); } catch (\Exception $e) { logger('SCV Flow: ' . $e->getMessage()); } } private function bind_latest_field($dl_key) { $scvflow = Scvflow::get_request($dl_key); foreach ($this->latests as $key => $value) $scvflow->$key = $value; return $scvflow; } private function make_view_data($scvflow, $host_url) { $data = $scvflow->toArray(); $data['reason'] = $scvflow->why_denied; $data['operation'] = $scvflow->jpoperation; $data['applicant_summary'] = $scvflow->applicant_summary; $data['authorizer_summary'] = $scvflow->authorizer_summary; $data['authorizers_mailformat'] = $scvflow->authorizers_mailformat; $data['auth_url'] = Scvflow::get_auth_url($scvflow->dl_key, $host_url); $data['dl_url'] = Scvflow::get_dl_url($scvflow->dl_key, $host_url); return $data; } private function requested($scvflow, $data) { $from = $this->smtp_from; $from_name = $this->smtp_from_name; $view = ""; $user = $scvflow->applicant_user; $to = $scvflow->applicant_email; if ($scvflow->action_type == "upload") { $view = 'scvflow.mails.requested_to_applicant'; } else if ($scvflow->action_type == "download") { $view = 'scvflow.mails.requested_to_download_applicant'; } $subject = FlowMailSubjectCustomizer::parse($scvflow, IDX_FLOW_APPLICANT_REQ_SUBJECT); if ($to === '') throw new \Exception("申請者 '{$user}' にメールアドレスが登録されていないため、メールが送信できませんでした。"); Mail::send($view, $data, function($mail) use($from, $from_name, $to, $subject) { $mail->from($from, $from_name); $mail->to($to); $mail->subject($subject); }); if ($scvflow->action_type == "upload") { $view = 'scvflow.mails.requested_to_authorizer'; } else if ($scvflow->action_type == "download") { $view = 'scvflow.mails.requested_to_download_authorizer'; } if (FlowAuthorizer::getAuthorizersCount($scvflow->id) > 1) { $authorizers_id = FlowAuthorizer::getAuthorizersByFlowId($scvflow->id); foreach($authorizers_id as $authorizer_id) { $user = Scvuser::find($authorizer_id); $to = $user->email; $subject = FlowMailSubjectCustomizer::parse($scvflow, IDX_FLOW_AUTHORIZER_REQ_SUBJECT); if ($to === '') { throw new \Exception("承認者 '{$user}' にメールアドレスが登録されていないため、メールが送信できませんでした。"); } Mail::send($view, $data, function($mail) use($from, $from_name, $to, $subject) { $mail->from($from, $from_name); $mail->to($to); $mail->subject($subject); }); } } else { $user = $scvflow->authorizer_user; $to = $scvflow->authorizer_email; $subject = FlowMailSubjectCustomizer::parse($scvflow, IDX_FLOW_AUTHORIZER_REQ_SUBJECT); if ($to === '') { throw new \Exception("承認者 '{$user}' にメールアドレスが登録されていないため、メールが送信できませんでした。"); } Mail::send($view, $data, function($mail) use($from, $from_name, $to, $subject) { $mail->from($from, $from_name); $mail->to($to); $mail->subject($subject); }); } } private function authorized($scvflow, $data) { $from = $this->smtp_from; $from_name = $this->smtp_from_name; $user = $scvflow->applicant_user; $to = $scvflow->applicant_email; if ($scvflow->action_type == "upload") { $view = 'scvflow.mails.authorized_to_applicant'; $env = IDX_FLOW_APPLICANT_AUTH_SUBJECT; } else if ($scvflow->action_type == "download") { $view = 'scvflow.mails.authorized_to_download_applicant'; $env = IDX_FLOW_DOWNLOAD_AUTH_SUBJECT; } $subject = FlowMailSubjectCustomizer::parse($scvflow, $env); if ($to === '') throw new \Exception("申請者 '{$user}' にメールアドレスが登録されていないため、メールが送信できませんでした。"); Mail::send($view, $data, function($mail) use($from, $from_name, $to, $subject) { $mail->from($from, $from_name); $mail->to($to); $mail->subject($subject); }); } private function log_before_sending($scvflow) { logger('SCV Flow: SendReminderEmail.php'); logger('メールの送信を開始します--------'); logger('$this->act=' . $this->act); logger('$this->action_type=' . $this->action_type); logger('$scvflow->status=' . $scvflow->status); logger('$scvflow->filename=' . $scvflow->filename); logger('$scvflow->applicant_email=' . $scvflow->applicant_email); logger('$scvflow->authorizer_email=' . $scvflow->authorizer_email); logger('--------'); } } 