<?php
 namespace App\Libs; use App\User; use App\AdminPolicy; use App\Libs\ClusterHelper as CH; use Illuminate\Support\Facades\Hash; class AdminPasswordHelper { private $adminpolicy; private $user; private $username; private $password; private $ngwords; private $pwd_complexity_min = 6; private $pwd_generations_max = 24; public function __construct($organization_id, $username) { $adminpolicy = AdminPolicy::where('organization_id', $organization_id)->first(); if ($adminpolicy === null) { throw new \Exception('存在しない組織名を取得しようとしました'); } $this->adminpolicy = $adminpolicy; $this->username = $username; $this->user = User::getUserByName($this->username); } public function registerable($password, &$errmsgs) { $errmsgs = []; $adminpolicy = $this->adminpolicy; $min1 = $adminpolicy->pwd_length; $min2 = $adminpolicy->pwd_complexity ? $this->pwd_complexity_min : 0; $min = $min1 > $min2 ? $min1 : $min2; $this->validate_length($password, $min, $errmsgs); if ($adminpolicy->pwd_complexity) { $this->validate_ad_complexity($password, $this->username, $errmsgs); } if ($adminpolicy->pwd_ng_words !== '') { $this->validate_ngwords($password, $errmsgs); } return count($errmsgs) === 0; } public function changeable($password, &$errmsgs, $by_admin = false) { $errmsgs = []; $adminpolicy = $this->adminpolicy; $username = $this->username; $user = $this->user; if ($username === null) { $errmsgs[] = '該当するユーザが存在しません'; return false; } $min1 = $adminpolicy->pwd_length; $min2 = $adminpolicy->pwd_complexity ? $this->pwd_complexity_min : 0; $min = $min1 > $min2 ? $min1 : $min2; $this->validate_length($password, $min, $errmsgs); if ($adminpolicy->pwd_complexity) { $this->validate_ad_complexity($password, $username, $errmsgs); } if ($adminpolicy->pwd_ng_words !== '') { $this->validate_ngwords($password, $errmsgs); } if ($adminpolicy->pwd_min_term && !$by_admin) { $this->validate_min_term($errmsgs); } if ($adminpolicy->pwd_generation_limit) { $this->validate_generation_limit($password, $errmsgs); } return count($errmsgs) === 0; } public function expired() { $user = $this->user; $adminpolicy = $this->adminpolicy; $expired = false; $set_date = date('Y-m-d', strtotime($user->pwd_reset_at)); $max_term = $adminpolicy->pwd_max_term; if ($max_term == 0) { return $expired; } $expire_date = date('Y-m-d', strtotime($set_date . "+" . $max_term . "day")); $now = date('Y-m-d', time()); if (strtotime($now) >= strtotime($expire_date)) { $user->tmp_pwd = $user->password; $dbret = $user->save(); $slave_dbret = ''; if(CH::isCluster()) { if(CH::isMasterActive() && $dbret) { if(CH::isSlaveAlive() && CH::isSlaveActive()) { $slavemodel = new User; $slavemodel->setConnection('slave_database'); $slaveuser = $slavemodel->getUserByName($user->username); $slaveuser->tmp_pwd = $user->password; $slave_dbret = $slaveuser->save(); } } CH::updateClusters($dbret, $slave_dbret); } $expired = true; } return $expired; } public function needs_to_alert() { $need = 0; $user = $this->user; $adminpolicy = $this->adminpolicy; $warn_limit = $adminpolicy->pwd_warning_term; $max_term = $adminpolicy->pwd_max_term; if ($warn_limit == 0 || $max_term == 0) { return $need; } $set_date = date('Y-m-d', strtotime($user->pwd_reset_at)); $expire_date = strtotime(date('Y-m-d', strtotime($set_date . "+" . $max_term . "day"))); $now = strtotime(date('Y-m-d', time())); $limit_date = ($expire_date - $now) / (60 * 60 * 24); if ($limit_date <= $warn_limit || $now == $expire_date ) { $need = 1; } return $need; } public function get_warn_date() { $user = $this->user; $adminpolicy = $this->adminpolicy; $warn_limit = $adminpolicy->pwd_warning_term; $set_date = date('Y-m-d', strtotime($user->pwd_reset_at)); $max_term = $adminpolicy->pwd_max_term; $expire_date = strtotime(date('Y-m-d', strtotime($set_date . "+" . $max_term . "day"))); $now = strtotime(date('Y-m-d', time())); $limit_date = ($expire_date - $now) / (60 * 60 * 24); if ($limit_date == 0) { return 'このユーザのパスワードは本日失効します、必ず変更してください。'; } return 'このユーザのパスワード有効期限が切れるまで、あと'.$limit_date.'日です。'; } public function get_added_new_generations($hash) { $saved_max = $this->pwd_generations_max; $limit = $this->adminpolicy->pwd_generation_limit; $hashes = $this->get_generations_array(); $hashes[] = $hash; if (count($hashes) > $saved_max) { $offset = count($hashes) - $saved_max; $hashes = array_slice($hashes, $offset, $saved_max); } return join(',', $hashes); } private function get_generations_array() { $hash_txt = $this->user->pwd_generations; $hashes = explode(',', $hash_txt); if ($hashes[0] === '') return []; return $hashes; } private function validate_length($password, $min, &$errmsgs) { if ($min > mb_strlen($password)) { $errmsgs[] = 'パスワードは' . $min . '文字以上で設定する必要があります'; } } private function validate_ad_complexity($password, $username, &$errmsgs) { if (!$this->has_3type_chars($password)) { $errmsgs[] = 'パスワードは大文字、小文字、数字、記号のうち3種類以上を含んでいる必要があります'; } if ($this->has_3chars_of_username($password, $username)) { $errmsgs[] = 'ユーザ名に含まれる連続した3文字をパスワードに含めることはできません'; } } private function validate_ngwords($password, &$errmsgs) { $ngwords = $this->get_ngwords(); foreach ($ngwords as $ngword) { if (strpos($password, $ngword) !== false) { $errmsgs[] = 'パスワードに使用できない単語が含まれています'; } } } private function validate_min_term(&$errmsgs) { if ($this->is_first_change()) return; $min_term = $this->adminpolicy->pwd_min_term; $passed_days = $this->get_passed_days(); if ($min_term > $passed_days) $errmsgs[] = 'あと' . $min_term . '日経つまでパスワードは変更できません'; } private function validate_generation_limit($password, &$errmsgs) { $limit = $this->adminpolicy->pwd_generation_limit; $hashes = $this->get_generations_array(); $matched = false; for ($i = 0; $i < $limit; ++$i) { $hash = array_pop($hashes); if ($hash === null) { break; } if (Hash::check($password, $hash)) { $matched = true; break; } } if ($matched) { $errmsgs[] = '過去に使用したパスワードと重複しています'; } } private function has_3chars_of_username($password, $username) { $i = 0; $sight = 3; $len = mb_strlen($username); if ($sight > $len) return false; do { $part = mb_substr($username, $i, $sight); if (strpos($password, $part) !== false) { return true; } } while (++$i <= ($len - $sight)); return false; } private function has_3type_chars($password) { $cnt = 0; if (preg_match('/[A-Z]/', $password)) ++$cnt; if (preg_match('/[a-z]/', $password)) ++$cnt; if (preg_match('/[0-9]/', $password)) ++$cnt; if (preg_match('/[!-\\/:-@\[-`{-~]/', $password)) ++$cnt; return $cnt >= 3; } private function get_ngwords() { $plain = $this->adminpolicy->pwd_ng_words; $ngwords = explode("\n", $plain); $ngwords = array_map('trim', $ngwords); $ngwords = array_filter($ngwords, 'strlen'); $ngwords = array_values($ngwords); return $ngwords; } private function get_passed_days() { $reset_at = $this->user->pwd_reset_at; $reset_at = $this->round_date($reset_at); $now_date = date('Y-m-d H:i:s'); $now_date = $this->round_date($now_date); $diff_sec = strtotime($now_date) - strtotime($reset_at); $diff_day = (int)($diff_sec / (60 * 60 * 24)); return $diff_day; } private function round_date($date) { $time = strtotime($date); $date = date('Y-m-d 00:00:00', $time); return $date; } private function is_first_change() { return $this->user->pwd_reset_at === '0000-00-00 00:00:00'; } public static function generate_salt() { $bytes = openssl_random_pseudo_bytes(4, $cstrong); return bin2hex($bytes); } public static function generate_hash($pwd, $salt = null) { if ($salt === null) $salt = self::generate_salt(); return crypt($pwd, '$6$' . $salt); } public function checkLockCount() { $user = $this->user; $adminpolicy = $this->adminpolicy; if ($user->deny_cnt >= $adminpolicy->lock_limit) { return true; } return false; } public function addLockCount() { $user = $this->user; $user->deny_cnt = $user->deny_cnt + 1; $dbret = $user->save(); $slave_dbret = ''; if(CH::isCluster()) { if(CH::isMasterActive() && $dbret) { if(CH::isSlaveAlive() && CH::isSlaveActive()) { $slavemodel = new User; $slavemodel->setConnection('slave_database'); $slaveuser = $slavemodel->where('username', $user->username)->first(); $slaveuser->deny_cnt = $user->deny_cnt; $slave_dbret = $slaveuser->save(); } } CH::updateClusters($dbret, $slave_dbret); } } public function getLockStatus() { $user = $this->user; $adminpolicy = $this->adminpolicy; $count = ($adminpolicy->lock_limit - $user->deny_cnt); if ($count > 0) { return "あと${count}回パスワードを連続で間違えた場合、アカウントがロックアウトされます。"; } else if ($count == 0) { return "アカウントがロックアウトされました、パスワードをリセットしてください。"; } else { return "このアカウントはロックアウトされています。パスワードをリセットしてください。"; } } public function checkLockSetting() { $adminpolicy = $this->adminpolicy; if ($adminpolicy->lock_limit > 0) { return true; } return false; } public function resetLockCount() { $user = $this->user; $user->deny_cnt = 0; $dbret = $user->save(); $slave_dbret = ''; if(CH::isCluster()) { if(CH::isMasterActive() && $dbret) { if(CH::isSlaveAlive() && CH::isSlaveActive()) { $slavemodel = new User; $slavemodel->setConnection('slave_database'); $slaveuser = $slavemodel->where('username', $user->username)->first(); $slaveuser->deny_cnt = 0; $slave_dbret = $slaveuser->save(); } } CH::updateClusters($dbret, $slave_dbret); } } } 