<?php
namespace App\Libs; class BatchCsvManager { private $batcsvcol = null; private $callbk_proc = null; private $success_rows = []; private $fail_rows = []; static public function create_column_object() { return new BatchCsvColumn(); } public function __construct($batcsvcol) { $this->batcsvcol = $batcsvcol; } public function create_ul_csv($rawcsv, $callbk_proc) { $csv_map = []; $batcsvrows = $this->csv_to_row_objects($rawcsv); foreach ($batcsvrows as $batcsvrow) { $callbk_proc($batcsvrow); } return $this->row_objects_to_csv($batcsvrows); } public function row_objects_to_csv($batcsvrows) { $fp = fopen('php://temp','w'); fwrite($fp, $this->generate_example_comment() . PHP_EOL); foreach ($batcsvrows as $batcsvrow) { $values = $batcsvrow->to_array(); fputcsv($fp, $values); } rewind($fp); $rawcsv = stream_get_contents($fp); fclose($fp); return $rawcsv; } public function csv_to_row_objects($rawcsv) { $columns = $this->batcsvcol->get_columns(); $column_cnt = count($columns); $batcsvrows = []; $fp = tmpfile(); fwrite($fp, $rawcsv); rewind($fp); while (($csvrow = fgetcsv($fp, 1000, ',')) !== false) { $rawrow = implode($csvrow); if (preg_match('/^#|^\s*$/', $rawrow)) continue; $batcsvrows[] = $this->create_row_object($csvrow); } fclose($fp); return $batcsvrows; } public function generate_example_comment() { $column_cols = []; $valtype_cols = []; $create_cols = []; $update_cols = []; $delete_cols = []; $example_cols = []; $batcsvcol = $this->batcsvcol; $columns = $batcsvcol->get_columns(); foreach ($columns as $column) { $column_obj = $batcsvcol->$column; $column_cols[] = $column_obj->header; $valtype_cols[] = $column_obj->description; $create_cols[] = $column_obj->required_add ? '必須' : ''; $update_cols[] = $column_obj->required_edit ? '必須' : ''; $delete_cols[] = $column_obj->required_del ? '必須' : ''; $example_cols[] = $column_obj->example; } $column_row = join(',', $column_cols); $valtype_row = join(',', $valtype_cols); $create_row = join(',', $create_cols); $update_row = join(',', $update_cols); $delete_row = join(',', $delete_cols); $example_row = join(',', $example_cols); $comment = ''; $comment .= "#---------------------------------------------------------------------------------\n"; $comment .= "# ※操作列に追加、変更、削除のいずれかを入力し、必要項目を入力してください。\n"; $comment .= "# ※組織名、ユーザ名、グループ名は必須項目です。\n"; $comment .= "# ※空行、空白のみ、操作列が追加、変更、削除以外または#で始まる場合は処理をスキップします。\n"; $comment .= "# ※処理結果列は処理後に更新されます。\n"; $comment .= "#---------------------------------------------------------------------------------\n"; $comment .= "# {$column_row}\n"; $comment .= "# {$valtype_row}\n"; $comment .= "# {$example_row}\n"; $comment .= "#---------------------------------------------------------------------------------\n"; $comment .= "# {$column_row}"; return $comment; } public function create_row_object($csvrow = null) { return $csvrow === null ? new BatchCsvRow($this->batcsvcol) : new BatchCsvRow($this->batcsvcol, $csvrow); } public static function response_csv($filename, $rawcsv) { return \Response::make($rawcsv, 200, [ 'Content-Type' => 'text/csv', 'Content-Disposition' => 'attachment; filename="' . $filename . '"' ])->cookie('EXPORTED', 'EXPORTED', 1, "", "", false, false); } }; class BatchCsvColumn { private $columns = []; private $column_dic = []; private $last_index = 0; public function add($column, $header, $description, $example, $required_add, $required_edit, $required_del) { $struct = $this->new_column_struct(); $struct->index = $this->last_index++; $struct->header = $header; $struct->description = $description; $struct->example = $example; $struct->required_add = $required_add; $struct->required_edit = $required_edit; $struct->required_del = $required_del; $this->column_dic[$column] = $struct; $this->columns[] = $column; } private function new_column_struct() { return new class { public $index = -1; public $header = ''; public $description = ''; public $example = ''; public $required_add = false; public $required_edit = false; public $required_del = false; }; } public function __get($key) { if (!isset($this->column_dic[$key])) throw new \Exception("存在しないカラム {$key} を参照しようとしました"); return $this->column_dic[$key]; } public function get_columns() { return $this->columns; } } class BatchCsvRow { private $batcsvcol = null; private $column_dic = []; private $failed = false; public function __construct($batcsvcol, $csvrow = null) { $this->batcsvcol = $batcsvcol; $columns = $batcsvcol->get_columns(); if ($csvrow !== null) { $this->init_by_csvrow($csvrow); $this->validate_column_count($csvrow); } else { $this->init_empty(); } } private function init_by_csvrow($csvrow) { $columns = $this->batcsvcol->get_columns(); foreach ($columns as $column) { $index = $this->batcsvcol->$column->index; $value = isset($csvrow[$index]) ? $csvrow[$index] : ''; $this->column_dic[$column] = $value; } } private function init_empty() { $columns = $this->batcsvcol->get_columns(); foreach ($columns as $column) $this->column_dic[$column] = ''; } public function __get($key) { if (!isset($this->column_dic[$key])) throw new \Exception("存在しないカラム {$key} を参照しようとしました"); return $this->column_dic[$key]; } public function __set($key, $value) { if (!isset($this->column_dic[$key])) throw new \Exception("存在しないカラム {$key} に代入しようとしました"); $this->column_dic[$key] = $value; } public function to_array() { $batcsvcol = $this->batcsvcol; $column_dic = $this->column_dic; $values = []; foreach ($column_dic as $column => $value) { $index = $batcsvcol->$column->index; $values[$index] = $value; } return $values; } public function is_failed() { return $this->failed; } public function set_failed($errmsg) { $this->result = $errmsg; $this->failed = true; } private function validate_column_count($csvrow) { $batcsvcol = $this->batcsvcol; $columns = $batcsvcol->get_columns(); $column_cnt = count($columns); $cnt = count($csvrow); if ($cnt < $column_cnt) $this->set_failed('項目が' . ($column_cnt - $cnt) . '個足りません'); elseif ($cnt > $column_cnt) $this->set_failed('項目が' . ($cnt - $column_cnt) . '個過剰です'); } public function get_action_english() { $action = $this->action; if ($action === '追加') return 'store'; if ($action === '変更') return 'update'; if ($action === '削除') return 'destroy'; return 'undefined'; } } 