<?php
namespace App\Libs; use DB; use App\Cluster; use App\Scvuser; use App\Scvgroup; class ClusterHelper { private static $scvconf_path = "/var/www/html/scv/.scvconf"; private static $timemilli; public static function isCluster() { $path = self::$scvconf_path; exec("sudo cat $path | grep ^SCV_CLUSTER= | cut -d = -f 2", $cluster); return $cluster[0] == 1 ? true : false; } public static function isMaster() { $path = self::$scvconf_path; exec("cat $path | grep SCV_CLUSTROLE= | cut -d = -f 2", $role); $role = strtolower($role[0]); return $role == 'master' ? true : false; } public static function isSlave() { $path = self::$scvconf_path; exec("cat $path | grep SCV_CLUSTROLE= | cut -d = -f 2", $role); $role = strtolower($role[0]); return $role == 'slave'; } public static function getRole() { $path = self::$scvconf_path; exec("cat $path | grep SCV_CLUSTROLE= | cut -d = -f 2", $role); return strtolower($role[0]); } public static function getSlaveHost() { $path = self::$scvconf_path; exec("sudo cat $path | grep ^SCV_CLUSTSLAVE= | cut -d = -f 2", $cluster); return !empty($cluster) ? $cluster[0] : ""; } public static function getClustid() { $path = self::$scvconf_path; exec("sudo cat $path | grep ^SCV_CLUSTID= | cut -d = -f 2", $cluster); return !empty($cluster) ? $cluster[0] : ""; } public static function getMasterAddress() { $path = self::$scvconf_path; exec("sudo cat $path | grep ^SCV_CLUSTMASTER= | cut -d = -f 2", $cluster); return !empty($cluster) ? $cluster[0] : "" ; } public static function getMasterUrl() { $url_prefix = substr(url()->current(), 0, 5); $http = $url_prefix === 'https' ? 'https://' : 'http://'; $manager_url = $http . self::getMasterAddress(); return $manager_url; } public static function isMasterAlive() { $host = self::getMasterAddress(); $ping_ret = exec("scvclustd -ping $host; echo $?"); return $ping_ret == 0 ? true : false; } public static function isMasterActive() { $query = Cluster::where('role', 'Master')->where(function($query) { $query->where('status', '100'); $query->orWhere('status', '101'); $query->orWhere('status', '110'); }); if ($query->count() == 0) { logger('isMasterActive : Master is not active'); return false; } return true; } public static function isMasterUpdating() { $address = self::getMasterAddress(); $cluster = Cluster::where('role', 'Master')->where('status','101')->count(); return $cluster != 0 ? true : false; } public static function isSlaveAlive() { $host = self::getSlaveHost(); $retry_count = 5; $inactive_count = Cluster::where('role', 'slave')->where('status', '200')->count(); if($inactive_count = 1) $retry_count = 2; $ret = exec("scvclustd -ping $host $retry_count ; echo $?"); if($ret != "0") logger("isSlaveAlive : slave is not alive"); return $ret == "0" ? true : false; } public static function isSlaveActive() { $query = Cluster::where('role', 'Slave')->where(function($query) { $query->where('status', '100'); $query->orWhere('status', '101'); $query->orWhere('status', '110'); }); if ($query->count() == 0) { logger('isSlaveActive : Slave is not active'); return false; } return true; } public static function isSlaveUpdating() { $path = self::$scvconf_path; $host = self::getSlaveHost(); $cluster = Cluster::where('ipaddress', $host)->where('status','101')->count(); return $cluster != 0 ? true : false; } public static function getTimemill() { if (self::$timemilli === null) self::$timemilli = floor(microtime(true) * 1000); return self::$timemilli; } public static function needsToSyncSlave() { return self::isCluster() && self::isMaster() && self::isSlaveActive() && self::isSlaveAlive(); } public static function update_clusters_if_necessary($dbret, $slave_dbret) { if (!self::isCluster()) return; if (self::isMaster() && self::isSlaveAlive() && self::isSlaveActive()) { self::updateClusters($dbret, $slave_dbret); } else if (self::isMaster()) { self::updateClusters($dbret, false); } else if (self::isSlave()) { self::updateClusters(false, $dbret); } else { throw new \Exception('MemberサーバでDBを変更しようとしました'); } } public static function updateClusters($dbret, $slavedbret, $timemilli = null) { if($dbret && $slavedbret){ return; } $sem = sem_get(config('scv.clust_sem_key')); if(!$sem){ logger('Failed to get semaphore - sem_get()'); } sem_acquire($sem, false); if ($timemilli === null) $timemilli = self::getTimemill(); logger("dbret : $dbret"); logger("slavedbret : $slavedbret"); logger("timemilli : $timemilli"); if($dbret && !$slavedbret){ logger("update only master clusters table"); DB::table('clusters')->sharedLock()->where('role', 'MASTER')->increment('dbwrite_count', 1, ['last_writemill' => $timemilli]); }else if($slavedbret && !$dbret){ logger("update only slave clusters table"); DB::table('clusters')->sharedLock()->where('role', 'SLAVE')->increment('dbwrite_count', 1, ['last_writemill' => $timemilli]); } } public static function updateTplUpdatemill($milli_time = null) { if($milli_time == null){ $milli_time = floor(microtime(true) * 1000); } return \DB::table('clusters')->lockForUpdate()->where('role','MASTER')->update(['tpl_updatemill' => $milli_time]); } public static function slave_shell_exec($cmd) { if (!self::isSlaveAlive() || !self::isSlaveActive()) return; static $ssh = null; if ($ssh === null) $ssh = 'sudo -i -u scvrun ssh scvrun@' . self::getSlaveHost(); return shell_exec($ssh . ' "' . $cmd . '"'); } public static function saveScvuserToSlaveDB($scvuser) { $slave_user = new Scvuser; $slave_user->setConnection('slave_database'); $fields = Scvuser::get_fields(['id']); self::copy_fields($scvuser, $slave_user, $fields); $slave_user->id = $scvuser->id; $slave_dbret = $slave_user->save(); return $slave_dbret; } public static function updateScvuserToSlaveDB($scvuser) { $slave_user = new Scvuser; $slave_user->setConnection('slave_database'); $slave_user = $slave_user->find($scvuser->id); if ($slave_user === null) { throw new \Exception("ID {$scvuser->id} に対応するユーザがSlaveに存在しませんでした"); } $fields = Scvuser::get_fields(['id']); self::copy_fields($scvuser, $slave_user, $fields); $slave_dbret = $slave_user->save(); return $slave_dbret; } public static function deleteScvuserToSlaveDB($scvuser) { $slave_dbret = \DB::connection('slave_database') ->table('scvusers') ->where('id', $scvuser->id) ->delete(); return $slave_dbret; } private static function copy_fields($src, &$dest, $fields) { try { foreach ($fields as $field) { if ($src->$field !== null) $dest->$field = $src->$field; } } catch (\Exception $e) { $msg = $e->getMessage(); throw new \Exception("'{$field}' フィールドの代入に失敗しました ErrMsg:{$msg}"); } } public static function saveScvgroupToSlaveDB($scvgroup) { $slaveGroup = new Scvgroup; $slaveGroup->setConnection('slave_database'); $fields = Scvgroup::get_fields(); self::copy_fields($scvgroup, $slaveGroup, $fields); return $slaveGroup->save(); } public static function updateScvgroupToSlaveDB($scvgroup) { $slaveGroup = new Scvgroup; $slaveGroup->setConnection('slave_database'); $slaveGroup = $slaveGroup->find($scvgroup->id); if ($slaveGroup === null) throw new \Exception("Slaveに id:{$scvgroup->id} のグループが存在しません"); $fields = Scvgroup::get_fields(['id']); self::copy_fields($scvgroup, $slaveGroup, $fields); return $slaveGroup->save(); } public static function deleteScvgroupToSlaveDB($id) { return \DB::connection('slave_database') ->table('scvgroups') ->where('id', $id) ->delete(); } } 