<?php
 namespace App\Libs; use App\Scvuser; class FlowMailSubjectCustomizer { public static function parse($scvflow, $idx) { $fmts = self::load_subject_format(); $vars = self::create_flow_curly_vars($scvflow); if ($idx >= count($fmts)) throw new \Exception('存在しないインデックスのフォーマットが指定されました'); return self::parse_curly_vars($fmts[$idx], $vars); } public static function load_subject_format() { $fmts = []; $fmts[0] = config('scvflow.applicant_req_subject'); $fmts[1] = config('scvflow.authorizer_req_subject'); $fmts[2] = config('scvflow.applicant_auth_subject'); $fmts[3] = config('scvflow.download_auth_subject'); if ($fmts[0] === null) $fmts[0] = '@SCV Flow: "{filename}" の承認申請が受理されました'; if ($fmts[1] === null) $fmts[1] = '@SCV Flow: "{filename}" の承認申請が届いています'; if ($fmts[2] === null) $fmts[2] = '@{authorizer_summary} が "{filename}" のアップロード申請を{operation}しました'; if ($fmts[3] === null) $fmts[3] = '@{authorizer_summary} が "{filename}" のダウンロード申請を{operation}しました'; return $fmts; } public static function create_flow_curly_vars($scvflow) { $applicant = Scvuser::find($scvflow->applicant_id); $authorizer = Scvuser::find($scvflow->authorizer_id); $vars = [ 'dl_key' => $scvflow->dl_key, 'action_type' => $scvflow->action_type, 'filename' => $scvflow->filename, 'filesize' => number_format($scvflow->filesize / 1024 + 1) . 'KB', 'comment' => $scvflow->comment, 'reason' => $scvflow->why_denied, 'status' => $scvflow->jpstatus, 'operation' => $scvflow->jpoperation, 'organization' => $scvflow->organization, 'applicant_name' => self::get_scvuser_value($applicant, 'name'), 'applicant_jpname' => self::get_scvuser_value($applicant, 'jpname'), 'applicant_department' => self::get_scvuser_value($applicant, 'department'), 'applicant_post' => self::get_scvuser_value($applicant, 'post'), 'applicant_summary' => $scvflow->applicant_summary, 'authorizer_name' => self::get_scvuser_value($authorizer, 'name'), 'authorizer_jpname' => self::get_scvuser_value($authorizer, 'jpname'), 'authorizer_department' => self::get_scvuser_value($authorizer, 'department'), 'authorizer_post' => self::get_scvuser_value($authorizer, 'post'), 'authorizer_summary' => $scvflow->authorizer_summary, 'requested_at' => $scvflow->requested_at, 'authorized_at' => $scvflow->authorized_at ]; return $vars; } private static function get_scvuser_value($scvuser, $field) { try { return $scvuser->$field; } catch (\Exception $e) { logger('FlowMailSubjectCustomizer::get_scvuser_value()'); logger($e->getMessage()); return '（取得失敗）'; } } private static function parse_curly_vars($input, $vars) { $keys = array_keys($vars); $symbol = implode('|', $keys); $pattern = '/(?<!\\\\)(?<bslash>(\\\\\\\\)*){(?<varname>' . $symbol . ')}/u'; $output = preg_replace_callback($pattern, function($m) use($vars) { $bslash = $m['bslash']; $varname = $m['varname']; $value = $vars[$varname]; return $bslash . $value; }, $input); return $output; } } 