<?php
namespace App\Libs; use App\Scvuser; use PragmaRX\Google2FA\Google2FA; class GAuthManager { private $g2fa; private $scvuser; public function __construct(Scvuser $scvuser) { $this->g2fa = new Google2FA(); $this->scvuser = $scvuser; if ($this->g2fa === null || $this->scvuser === null) throw new \Exception('2要素認証の初期化に失敗しました'); } public function renew_secretkey() { $id = $this->scvuser->id; $secretkey = $this->g2fa->generateSecretKey(); $cnt = Scvuser::where('id', $id)->update(['gauth_key' => $secretkey]); if (!$cnt) throw new \Exception('秘密鍵の割り当てに失敗しました'); $this->scvuser->gauth_key = $secretkey; } public function get_secretkey() { return (string)$this->scvuser->gauth_key; } public function verify_password($pwd) { if (!$this->get_secretkey()) throw new \Exception('ユーザに秘密鍵が割り当てられていません'); return $this->g2fa->verifyKey( $this->scvuser->gauth_key, (string)$pwd ); } public function get_qr_url() { if (!$this->get_secretkey()) throw new \Exception('ユーザに秘密鍵が割り当てられていません'); $this->g2fa->setAllowInsecureCallToGoogleApis(true); $qr_url = $this->g2fa->getQRCodeGoogleUrl( 'SCVX', $this->scvuser->email, $this->scvuser->gauth_key ); return $qr_url; } public function output_qr() { $url = $this->get_qr_url(); $data = file_get_contents($url); header('Content-type: image/png'); exit($data); } public function get_enc_qr() { if ($this->get_secretkey() === '') $this->renew_secretkey(); $url = $this->get_qr_url(); $png = file_get_contents($url); return base64_encode($png); } } 