<?php
 namespace App\Libs; use App\Models\LdapSetting; use App\Exceptions\LdapException; class LdapHelper { public static function ldapsearch(LdapSetting $setting): array { static::checkExtensionLoaded(); $host = $setting->host; $port = $setting->port; $user = $setting->user; $password = $setting->password; $dn = $setting->dn; $filter = $setting->filter ?: LdapSetting::DEFAULT_LDAP_FILTER; $username_attr = $setting->username_attr ?: LdapSetting::DEFAULT_LDAP_USERNAME_ATTR; $attrs = self::toAttrs($setting); try { $con = static::connectBind($host, $port, $user, $password); $users = static::searchUsers($con, $dn, $filter, $username_attr, $attrs); return $users; } finally { @ldap_unbind($con); } } private static function toAttrs(LdapSetting $setting): array { $attrs = []; $attrs['mail_attr'] = $setting->mail_attr; $attrs['employee_id_attr'] = $setting->employee_id_attr; $attrs['jpname_attr'] = $setting->jpname_attr; $attrs['department_attr'] = $setting->department_attr; $attrs['post_attr'] = $setting->post_attr; $attrs['custom_data1_attr'] = $setting->custom_data1_attr; $attrs['custom_data2_attr'] = $setting->custom_data2_attr; $attrs['custom_data3_attr'] = $setting->custom_data3_attr; $attrs['privilege_attr'] = $setting->privilege_attr; $attrs['flow_group_attr'] = $setting->flow_group_attr; $attrs['comment_attr'] = $setting->comment_attr; return $attrs; } public static function ldapauth(LdapSetting $setting, string $username, string $plainPassword): bool { static::checkExtensionLoaded(); $host = $setting->host; $port = $setting->port; $searcherUsername = $setting->user; $searcherPassword = $setting->password; $baseDn = $setting->dn; $baseFilter = $setting->filter ?: LdapSetting::DEFAULT_LDAP_FILTER; $username_attr = $setting->username_attr ?: LdapSetting::DEFAULT_LDAP_USERNAME_ATTR; $username = static::escapeLdapFilterString($username); $userfilter = sprintf("(&%s(%s=%s))", $baseFilter, $username_attr, $username); try { $con = static::connectBind($host, $port, $searcherUsername, $searcherPassword); $entry = static::searchEntry($con, $baseDn, $userfilter); if (is_null($entry)) { return false; } else { $userdn = $entry; } } finally { @ldap_unbind($con); } try { $con2 = static::connectBind($host, $port, $userdn, $plainPassword); } catch (LdapException $e) { return false; } finally { @ldap_unbind($con2); } return true; } private static function checkExtensionLoaded() { if (!extension_loaded('ldap')) { throw new LdapException("ldap extension is not available"); } } private static function connectBind(string $server, int $port, string $dn, string $password) { $con = @ldap_connect($server, $port); if (!$con) { throw new LdapException("LDAPサーバに接続できません"); } ldap_set_option($con, LDAP_OPT_REFERRALS, 0); ldap_set_option($con, LDAP_OPT_PROTOCOL_VERSION, 3); $isBindOk = @ldap_bind($con, $dn, $password); if (!$isBindOk) { if (ldap_error($con)=="Invalid credentials") { $msg = "無効なアカウントです"; } else { $msg = ldap_error($con); } throw new LdapException($msg); } return $con; } private static function searchUsers($con, string $dn, string $filter, string $username_attr, array $attrs): array { $username_attr = strtolower($username_attr); foreach ($attrs as $key => $ldapAttr) { $attrs[$key] = strtolower($ldapAttr); } $result = @ldap_search($con, $dn, $filter); $err_msg = ldap_error($con) ?? ""; $msg = ""; if (!$result || $err_msg != 'Success') { if ($err_msg == "Bad search filter") { $msg = "フィルターの書式が間違っています"; } else if ($err_msg == "Size limit exceeded") { $msg = "取得上限を超過しました"; } else { $msg = $err_msg; } logger($err_msg); throw new LdapException($msg); } $entries = ldap_get_entries($con, $result); $users = array(); for ($i = 0; $i < $entries["count"]; $i++) { if (!isset($entries[$i][$username_attr])) { continue; } $users[] = (object) [ 'name' => $entries[$i][$username_attr][0], 'mail' => @$entries[$i][$attrs['mail_attr']][0] ?: '', 'employee_id' => @$entries[$i][$attrs['employee_id_attr']][0] ?: '', 'jpname' => @$entries[$i][$attrs['jpname_attr']][0] ?: '', 'department' => @$entries[$i][$attrs['department_attr']][0] ?: '', 'post' => @$entries[$i][$attrs['post_attr']][0] ?: '', 'custom_data1' => @$entries[$i][$attrs['custom_data1_attr']][0] ?: '', 'custom_data2' => @$entries[$i][$attrs['custom_data2_attr']][0] ?: '', 'custom_data3' => @$entries[$i][$attrs['custom_data3_attr']][0] ?: '', 'privilege' => @$entries[$i][$attrs['privilege_attr']] ? 1 : 0, 'flow_group' => @$entries[$i][$attrs['flow_group_attr']][0] ?: '', 'comment' => @$entries[$i][$attrs['comment_attr']][0] ?: '', ]; } return $users; } private static function searchEntry($con, string $dn, string $filter) { $result = @ldap_search($con, $dn, $filter); if (!$result) { if (ldap_error($con)=="Bad search filter") { $msg = "フィルターの書式が間違っています"; } else { $msg = ldap_error($con); } throw new LdapException($msg); } $entries = ldap_get_entries($con, $result); if ($entries["count"] == 1) { $userDn = $entries[0]["dn"]; } else { return null; } return $userDn; } public static function escapeLdapFilterString(string $str): string { $search = [ '\\', '(', ')', '*']; $replacement = ['\\\\', '\(', '\)', '\*']; return str_replace($search, $replacement, $str); } } 