<?php
declare(strict_types = 1); namespace App\Libs; use Illuminate\Console\Command; use App\Models\LdapSetting; use App\Organization; use App\Scvgroup; use App\Scvuser; use Carbon\Carbon; use Illuminate\Support\Collection; use App\Jobs\ScvuserJob; class LdapImportHelper { public static function matchLdapScvuser(LdapSetting $ldap): array { $ldapUsers = LdapHelper::ldapsearch($ldap); $scvusers = Scvuser::listScvusersByOrgId($ldap->organization_id)->all(); list($addUsers, $delUsers) = self::getUserDiff($ldapUsers, $scvusers, $ldap); $addUsers = self::excludeSystemUsers($addUsers); $delUsers = self::excludeSystemUsers($delUsers); return [ $addUsers, $delUsers ]; } private static function excludeSystemUsers(array $users): array { $excluded = array_filter($users, function ($u) { return !in_array($u->name, Scvuser::SYSTEM_USERS); }); return $excluded; } private static function getUserDiff(array $ldapusers, array $scvusers, LdapSetting $ldap) { $org = Organization::find($ldap->organization_id); $group = ScvGroup::find($ldap->groupid); $scvuserNames = []; $ldapuserNames = []; $ldapuserNamesLower = []; foreach ($scvusers as $su) { $scvuserNames[] = $su->name; } foreach ($ldapusers as $lu) { $ldapuserNames[] = $lu->name; $ldapuserNamesLower[] = mb_strtolower($lu->name); } $adduserNames = array_diff($ldapuserNamesLower, $scvuserNames); $addusers = []; foreach ($ldapusers as $lu) { if ($ldap->username_case_insensitive == '1') { $lu->name = mb_strtolower($lu->name); } if (!in_array($lu->name, $adduserNames)) { continue; } if (!self::isValidUser($org, $group, $lu->name, "store", $ldap, null, $lu)) { continue; } $addusers[] = $lu; } $delusers = []; foreach ($scvusers as $su) { if (in_array($su->name, $ldapuserNamesLower)) { continue; } if (!self::isValidUser($org, $group, $su->name, "destroy", $ldap, $su, null)) { continue; } $delusers[] = $su; } return [ $addusers, $delusers ]; } public static function synchronizeLdapScvusers(LdapSetting $ldap_setting, array $adduser, array $deluser, Carbon $searched_at, string $logFilePath = null, Command $command = null) { self::log($logFilePath, sprintf( 'Name: %s, Host: %s, Port: %d, DN: "%s", Filter: "%s"', $ldap_setting->name, $ldap_setting->host, $ldap_setting->port, $ldap_setting->dn, $ldap_setting->filter ) . PHP_EOL); self::log($logFilePath, "削除: " . number_format(count($deluser)) . PHP_EOL); self::log($logFilePath, "登録: " . number_format(count($adduser)) . PHP_EOL); foreach ($deluser as $du) { $args = [ "--del" => true, "--id" => $du->id, ]; $log = self::invokeScvuserCommand($args, $command); self::log($logFilePath, $log); } foreach ($adduser as $au) { $args = [ "--add" => true, "--name" => mb_strtolower($au->name), "--groupid" => $ldap_setting->groupid, "--email" => $au->mail, "--employee_id" => $au->employee_id, "--jpname" => $au->jpname, "--department" => $au->department, "--post" => $au->post, "--custom_data1" => $au->custom_data1, "--custom_data2" => $au->custom_data2, "--custom_data3" => $au->custom_data3, "--privilege" => $au->privilege, "--flow_group" => $au->flow_group, "--comment" => $au->comment, ]; $log = self::invokeScvuserCommand($args, $command); self::log($logFilePath, $log); } $ldap_setting->synced_at = $searched_at; LdapSetting::updateLdapSetting($ldap_setting->toArray(), $ldap_setting->id); } private static function invokeScvuserCommand(array $args, Command $command = null): string { if (is_null($command)) { \Artisan::call('scv:scvuser', $args); $log = \Artisan::output(); } else { $command->call('scv:scvuser', $args); $log = json_encode($args) . PHP_EOL; } return $log; } public static function getLogFilePath(): array { $filePath = null; $err = null; $logPath = ConfHelper::getBackupDirectory(); if (!$logPath) { $err = "バックアップディレクトリが設定されていないため、ログの書き込みに失敗しました。"; } elseif (!file_exists($logPath)) { $err = "バックアップディレクトリが存在しないため、ログの書き込みに失敗しました。"; } elseif (!is_writable($logPath)) { $err = "バックアップディレクトリに書き込み権限がないため、ログの書き込みに失敗しました。"; } else { $filename = date("YmdHis")."_ldaptoscvx.log"; $filePath = $logPath . "/" . $filename; } return [ $filePath, $err ]; } private static function log($filePath, string $msg) { if (is_null($filePath)) { return; } $fp = fopen($filePath, 'a'); try { fwrite($fp, Carbon::now()->format('Y/m/d H:i:s.u ') . $msg); } finally { fclose($fp); } } private static function isValidUser($org, $group, $name, $act, $ldap, $su, $lu) { $data = self::makeValidationData($org, $group, $name, $act, $ldap, $su, $lu); $userjob = new ScvuserJob($act, $data, true); $validator = \Validator::make($data, $userjob->rules($act)); if($validator->fails()){ logger($name, $validator->messages()->messages()); } return !$validator->fails(); } private static function makeValidationData($org, $group, $name, $act, $ldap, $su, $lu) { $data = [ 'organization' => $org->name, 'group' => $group->name, 'name' => $name ]; if ($act == "store" && $lu != null) { $data += [ 'email' => $lu->{$ldap->mail_attr} ?? '']; $data += [ 'employee_id' => $lu->{$ldap->employee_id_attr} ?? '' ]; $data += [ 'jpname' => $lu->{$ldap->jpname_attr} ?? '']; $data += [ 'department' => $lu->{$ldap->department_attr} ?? '']; $data += [ 'post' => $lu->{$ldap->post_attr} ?? '' ]; $data += [ 'custom_data1' => $lu->{$ldap->custom_data1_attr} ?? '']; $data += [ 'custom_data2' => $lu->{$ldap->custom_data2_attr} ?? '']; $data += [ 'custom_data3' => $lu->{$ldap->custom_data3_attr} ?? '']; $data += [ 'privilege' => $lu->{$ldap->privilege_attr} ?? '']; $data += [ 'flow_group' => $lu->{$ldap->flow_group_attr} ?? '']; $data += [ 'comment' => $lu->{$ldap->comment_attr} ?? '']; } else if ($act == "destroy" && $su != null) { $data += ['id' => $su->id ]; } return $data; } } 