<?php
namespace App\Libs; use App\Organization; use App\Scvuser; use Illuminate\Support\Facades\Hash; class PasswordPolicyManager { private $organization; private $scvuser; private $username; private $ngwords; private $pwd_complexity_min = 6; private $pwd_generations_max = 24; public function __construct($org, $user) { $organization = Organization::where('name', $org)->first(); if ($organization === null) throw new \Exception('存在しない組織名からパスワードポリシーを取得しようとしました'); $this->organization = $organization; $this->username = $user; $this->scvuser = Scvuser::with_org($org, $user); } public function registerable($pwd, &$errmsgs) { $errmsgs = []; $organization = $this->organization; $min1 = $organization->pwd_length; $min2 = $organization->pwd_complexity ? $this->pwd_complexity_min : 0; $min = $min1 > $min2 ? $min1 : $min2; $this->validate_length($pwd, $min, $errmsgs); if ($organization->pwd_complexity) $this->validate_ad_complexity($pwd, $this->username, $errmsgs); if ($organization->pwd_ngwords !== '') $this->validate_ngwords($pwd, $errmsgs); return count($errmsgs) === 0; } public function changeable($pwd, &$errmsgs, $by_admin = false) { $errmsgs = []; $organization = $this->organization; $scvuser = $this->scvuser; if ($scvuser === null) { $errmsgs[] = '該当するユーザが存在しません'; return false; } $min1 = $organization->pwd_length; $min2 = $organization->pwd_complexity ? $this->pwd_complexity_min : 0; $min = $min1 > $min2 ? $min1 : $min2; $this->validate_length($pwd, $min, $errmsgs); if ($organization->pwd_complexity) $this->validate_ad_complexity($pwd, $scvuser->name, $errmsgs); if ($organization->pwd_ngwords !== '') $this->validate_ngwords($pwd, $errmsgs); $not_tmppw = $scvuser->pwd_tmp_expired_at === '0000-00-00 00:00:00'; if ($organization->pwd_min_term && $not_tmppw && !$by_admin) $this->validate_min_term($errmsgs); if ($organization->pwd_generation_limit && !$by_admin) $this->validate_generation_limit($pwd, $errmsgs); return count($errmsgs) === 0; } public function expired() { $org = $this->organization->name; $user = $this->username; $output = `scvdirect -pwdpol {$org}/{$user}`; $expired = strpos($output, 'STAT:PWDEXPIRED') === 0; return $expired; } public function get_added_new_generations($hash) { $saved_max = $this->pwd_generations_max; $limit = $this->organization->pwd_generation_limit; $hashes = $this->get_generations_array(); $hashes[] = $hash; if (count($hashes) > $saved_max) { $offset = count($hashes) - $saved_max; $hashes = array_slice($hashes, $offset, $saved_max); } return join(',', $hashes); } private function get_generations_array() { $hash_txt = $this->scvuser->pwd_generations; $hashes = explode(',', $hash_txt); if ($hashes[0] === '') return []; return $hashes; } private function validate_length($pwd, $min, &$errmsgs) { if ($min > mb_strlen($pwd)) $errmsgs[] = 'パスワードは' . $min . '文字以上で設定する必要があります'; } private function validate_ad_complexity($pwd, $user, &$errmsgs) { if (!$this->has_3type_chars($pwd)) $errmsgs[] = 'パスワードは大文字、小文字、数字、記号のうち3種類以上を含んでいる必要があります'; if ($this->has_3chars_of_username($pwd, $user)) $errmsgs[] = 'ユーザ名に含まれる連続した3文字をパスワードに含めることはできません'; } private function validate_ngwords($pwd, &$errmsgs) { $ngwords = $this->get_ngwords(); foreach ($ngwords as $ngword) { if (strpos($pwd, $ngword) !== false) { $errmsgs[] = 'パスワードに使用できない単語が含まれています'; } } } private function validate_min_term(&$errmsgs) { if ($this->is_first_change()) return; $min_term = $this->organization->pwd_min_term; $passed_days = $this->get_passed_days(); if ($min_term > $passed_days) $errmsgs[] = 'あと' . $min_term . '日経つまでパスワードは変更できません'; } private function validate_generation_limit($pwd, &$errmsgs) { $limit = $this->organization->pwd_generation_limit; $hashes = $this->get_generations_array(); $matched = false; for ($i = 0; $i < $limit; ++$i) { $hash = array_pop($hashes); if ($hash === null) break; if (Hash::check($pwd, $hash)) { $matched = true; break; } } if ($matched) $errmsgs[] = '過去に使用したパスワードと重複しています'; } private function has_3chars_of_username($pwd, $user) { $i = 0; $sight = 3; $len = mb_strlen($user); if ($sight > $len) return false; do { $part = mb_substr($user, $i, $sight); if (strpos($pwd, $part) !== false) { return true; } } while (++$i <= ($len - $sight)); return false; } private function has_3type_chars($pwd) { $cnt = 0; if (preg_match('/[A-Z]/', $pwd)) ++$cnt; if (preg_match('/[a-z]/', $pwd)) ++$cnt; if (preg_match('/[0-9]/', $pwd)) ++$cnt; if (preg_match('/[!-\\/:-@\[-`{-~]/', $pwd)) ++$cnt; return $cnt >= 3; } private function get_ngwords() { $plain = $this->organization->pwd_ngwords; $ngwords = explode("\n", $plain); $ngwords = array_map('trim', $ngwords); $ngwords = array_filter($ngwords, 'strlen'); $ngwords = array_values($ngwords); return $ngwords; } private function get_passed_days() { $reset_at = $this->scvuser->pwd_reset_at; $reset_at = $this->round_date($reset_at); $now_date = date('Y-m-d H:i:s'); $now_date = $this->round_date($now_date); $diff_sec = strtotime($now_date) - strtotime($reset_at); $diff_day = (int)($diff_sec / (60 * 60 * 24)); return $diff_day; } private function round_date($date) { $time = strtotime($date); $date = date('Y-m-d 00:00:00', $time); return $date; } private function is_first_change() { return $this->scvuser->pwd_reset_at === '0000-00-00 00:00:00'; } } 