<?php
namespace App\Libs; use App\Organization; use App\Scvuser; use App\Libs\ClusterHelper; use App\Libs\ConfHelper; use App\Libs\PasswordPolicyManager; use Illuminate\Validation\ValidationException; use Illuminate\Support\Facades\Hash; class PasswordUpdator { public static function authenticate($org, $user, $pwd) { $validator = \Validator::make([], [], []); $validator->after(function($validator) use($org, $user, $pwd) { $scvuser = Scvuser::with_org($org, $user); if ($scvuser === null) return; if (!self::compare_password($scvuser, $pwd, $errmsg)) { $org_with_name = $org."/".$user; $scvuser = Scvuser::incrementPwdFailCount($org_with_name, $scvuser); if($scvuser->locked) { $validator->errors()->add('current_pwd', "アカウントがロックされています。管理者にお問い合わせください。"); } else { $validator->errors()->add('current_pwd', $errmsg); } } }); if ($validator->fails()) throw new ValidationException($validator); } public static function validate_registerable($org, $user, $pwd1, $pwd2) { $validator = self::validate_common($pwd1, $pwd2); $validator->after(function($validator) use($org, $user, $pwd1) { $ppm = new PasswordPolicyManager($org, $user); if (!$ppm->registerable($pwd1, $errmsgs)) { foreach ($errmsgs as $errmsg) $validator->errors()->add('pwd1', $errmsg); } }); if ($validator->fails()) throw new ValidationException($validator); } public static function validate_changeable($org, $user, $pwd1, $pwd2, $by_admin = false) { $validator = self::validate_common($pwd1, $pwd2); $validator->after(function($validator) use($org, $user, $pwd1, $by_admin) { $ppm = new PasswordPolicyManager($org, $user); if (!$ppm->changeable($pwd1, $errmsgs, $by_admin)) { foreach ($errmsgs as $errmsg) $validator->errors()->add('pwd1', $errmsg); } }); if ($validator->fails()) throw new ValidationException($validator); } public static function validate_temp_changeable($org, $user, $pwd1, $pwd2) { $validator = self::validate_common($pwd1, $pwd2); if ($validator->fails()) throw new ValidationException($validator); } private static function validate_common($pwd1, $pwd2) { $inputs = [ 'pwd1' => $pwd1, 'pwd2' => $pwd2 ]; $rules = [ 'pwd1' => ['required', 'same:pwd2', 'max:32', 'pass_rule'] ]; $messages = [ 'pwd1.required' => 'パスワードが入力されていません。', 'pwd1.same' => '確認用のパスワードと一致しません。', 'pwd1.max' => 'パスワードは最大32文字で入力してください。', 'pwd1.pass_rule' => 'パスワードに使用できない文字が含まれています。' ]; return \Validator::make($inputs, $rules, $messages); } private static function compare_password($scvuser, $pwd, &$errmsg) { $ok = self::compare_scvxlocal_password($scvuser, $pwd, $errmsg); return $ok; } private static function compare_scvxlocal_password($scvuser, $pwd, &$errmsg) { if (!Hash::check($pwd, $scvuser->password)) { $errmsg = 'パスワードが誤っています。'; return false; } return true; } public static function change_password($scvuser, $pwd, &$errmsg) { $ok = self::change_scvxlocal_password($scvuser, $pwd, $errmsg, false); $slave_dbret = 0; if (ClusterHelper::needsToSyncSlave()) $slave_dbret = ClusterHelper::updateScvuserToSlaveDB($scvuser); ClusterHelper::update_clusters_if_necessary($ok, $slave_dbret); return $ok; } public static function change_temp_password($scvuser, $pwd, &$errmsg, $term) { $ok = self::change_scvxlocal_password($scvuser, $pwd, $errmsg, true); $scvuser->pwd_tmp_expired_at = date('Y-m-d 00:00:00', strtotime("+{$term} day")); $scvuser->pwd_generations = ''; $scvuser->save(); $slave_dbret = 0; if (ClusterHelper::needsToSyncSlave()) $slave_dbret = ClusterHelper::updateScvuserToSlaveDB($scvuser); ClusterHelper::update_clusters_if_necessary($ok, $slave_dbret); return $ok; } private static function change_scvxlocal_password($scvuser, $pwd, &$errmsg, $tmppwd) { $salt = self::generate_salt(); $hash = self::generate_hash($pwd, $salt); $org = $scvuser->organization; $user = $scvuser->name; $ppm = new PasswordPolicyManager($org, $user); $added_generations = $ppm->get_added_new_generations($hash); $scvuser->password = $hash; if (!$tmppwd) { $scvuser->pwd_generations = $added_generations; $scvuser->pwd_reset_at = date('Y-m-d H:i:s'); $scvuser->pwd_tmp_expired_at = date('0000-00-00 00:00:00'); } $scvuser->locked = false; $scvuser->pwd_fail_count = 0; $dbret = $scvuser->save(); return $dbret; } public static function generate_salt() { $bytes = openssl_random_pseudo_bytes(4, $cstrong); return bin2hex($bytes); } public static function generate_hash($pwd, $salt = null) { if ($salt === null) $salt = self::generate_salt(); return crypt($pwd, '$6$' . $salt); } } 