<?php
 namespace App\Models; use Illuminate\Database\Eloquent\Model; use App\Libs\ClusterHelper as CH; class EdgeSetting extends Model { protected $guarded = ['id', 'created_at']; protected $casts = [ 'save_profile' => 'boolean', 'save_history' => 'boolean', 'save_password' => 'boolean', 'save_cookie' => 'boolean', 'save_bookmark' => 'boolean', 'hide_internal_pages' => 'boolean', 'enable_xff' => 'boolean', 'enable_pauth' => 'boolean' ]; public function getPauthPassAttribute($value) { if ($value === 'SCVUSER') { return $value; } $clear = exec("scvstr -d -- '$value'"); return $clear; } public function getPauthPassCipherAttribute() { return $this->attributes['pauth_pass']; } public function setPauthPassAttribute($value) { $pass = null; if ($value == "") { $pass = ""; } else if ($value === 'SCVUSER') { $pass = 'SCVUSER'; } else { $value = escapeshellarg($value); $cipher = exec("scvstr -e -- $value"); $pass = $cipher; } $this->attributes['pauth_pass'] = $pass; } public function managed_bookmarks() { return $this->belongsToMany(ManagedBookmark::class); } public static function create(array $attributes = []) { $setting = static::query()->create($attributes); $setting->relateManagedBookmarks($attributes['bookmarks']); if (CH::isCluster()) { $slave_setting = null; if (CH::isSlaveActive()) { $slave_setting = self::on('slave_database')->create($attributes); $slave_setting->relateManagedBookmarks($attributes['bookmarks']); } CH::updateClusters($setting != null, $slave_setting != null); } return $setting; } public static function updateEdgeSetting($params, $id) { $setting = parent::find($id); $ret = $setting->fill($params)->save(); $setting->relateManagedBookmarks($params['bookmarks']); if (CH::isCluster()) { $s_ret = false; if (CH::isSlaveActive()) { $slave_setting = self::on('slave_database')->find($id); $s_ret = $slave_setting->fill($params)->save(); $slave_setting->relateManagedBookmarks($params['bookmarks']); } CH::updateClusters($ret, $s_ret); } return $ret; } public static function destroy($ids) { parent::find($ids)->managed_bookmarks()->detach(); $count = parent::destroy($ids); if (CH::isCluster()) { $slave_count = 0; if (CH::isSlaveActive()) { self::on('slave_database')->find($ids)->managed_bookmarks()->detach(); $slave_count = self::on('slave_database')->find($ids)->delete(); } CH::updateClusters($count > 0, $slave_count > 0); } return $count; } private function relateManagedBookmarks(string $bookmarksStr) { $bookmarkIds = explode(',', $bookmarksStr); $relations = []; foreach ($bookmarkIds as $order => $bookmarkId) { $relations[$bookmarkId] = ['order' => $order]; } $this->managed_bookmarks()->sync($relations); } public function getBookmarkNamesAttribute(): array { $bookmarks = $this->managed_bookmarks() ->withPivot('order') ->orderBy('order') ->get(); $names = array_map(function ($b) { return $b->name; }, $bookmarks->all()); return $names; } } 