<?php
 namespace App\Models; use Illuminate\Database\Eloquent\Model; use Crypt; use App\Libs\ClusterHelper; use App\Organization; use App\Scvgroup; use Illuminate\Support\Collection; class LdapSetting extends Model { const DEFAULT_LDAP_PORT = 389; const DEFAULT_LDAP_FILTER = "(cn=*)"; const DEFAULT_LDAP_USERNAME_ATTR = "samaccountname"; const DEFAULT_LDAP_MAIL_ATTR = "mail"; protected $fillable = [ 'name', 'host', 'port', 'user', 'password', 'groupid', 'organization_id', 'dn', 'filter', 'username_attr', 'username_case_insensitive', 'mail_attr', 'employee_id_attr', 'jpname_attr', 'department_attr', 'post_attr', 'custom_data1_attr', 'custom_data2_attr', 'custom_data3_attr', 'privilege_attr', 'flow_group_attr', 'comment_attr', 'synced_at' ]; public function organization() { return $this->belongsTo(Organization::class); } public function group() { return $this->belongsTo(Scvgroup::class, 'groupid'); } public function getPasswordAttribute($password){ if($password){ return Crypt::decrypt($password); }else{ $password; } } public function setPasswordAttribute($password){ $this->attributes['password'] = Crypt::encrypt($password); } public function applyDefault() { $this->port = $this->port ?: self::DEFAULT_LDAP_PORT; $this->filter = $this->filter ?: self::DEFAULT_LDAP_FILTER; $this->username_attr = $this->username_attr ?: self::DEFAULT_LDAP_USERNAME_ATTR; $this->mail_attr = $this->mail_attr ?: self::DEFAULT_LDAP_MAIL_ATTR; } public static function create(array $attributes = []): LdapSetting { $masterResult = static::query()->create($attributes); if (ClusterHelper::isCluster()) { $isSlaveOk = false; if (ClusterHelper::isSlaveActive()) { $slaveResult = self::on('slave_database')->create($attributes); if ($slaveResult == null) { $isSlaveOk = false; } else if ($masterResult->id != $slaveResult->id) { $isSlaveOk = false; } else { $isSlaveOk = true; } } ClusterHelper::updateClusters($masterResult != null, $isSlaveOk); } return $masterResult; } public static function updateLdapSetting(array $attributes, int $id): bool { $masterLdap = parent::find($id); $isMasterOk = $masterLdap->fill($attributes)->save(); if (ClusterHelper::isCluster()) { $isSlaveOk = false; if (ClusterHelper::isSlaveActive()) { $slaveLdap = self::on('slave_database')->find($id); if (!isset($slaveLdap) || $masterLdap->id != $slaveLdap->id) { $isSlaveOk = false; } else { $isSlaveOk = $slaveLdap->fill($attributes)->save(); } } ClusterHelper::updateClusters($isMasterOk, $isSlaveOk); } return $isMasterOk; } public static function destroy($ids): int { $masterCount = parent::destroy($ids); $isMasterOk = $masterCount > 0; if (ClusterHelper::isCluster()) { $isSlaveOk = false; if (ClusterHelper::isSlaveActive()) { $slaveLdap = self::on('slave_database')->find($ids); if (!isset($slaveLdap)) { $isSlaveOk = false; } else { $slaveCount = $slaveLdap->delete(); $isSlaveOk = $slaveCount > 0; } } ClusterHelper::updateClusters($isMasterOk, $isSlaveOk); } return $masterCount; } public static function findByName(string $name): LdapSetting { return LdapSetting::where('ldap_settings.name', $name)->first(); } public static function listSelectableOrgIds(int $myId = null): array { $orgIds = Organization:: whereIn('id', function ($query) { $query->select('organization_id') ->from('scvgroups') ->groupBy('organization_id'); }) ->whereNotIn('id', function ($query) use ($myId) { $query->select('organization_id') ->from('ldap_settings') ->where('id', '<>', $myId); }) ->pluck('id')->toArray(); return $orgIds; } public static function isAllOrgsUsed(): bool { $numOrgs = Organization::count(); $numUsedOrgs = LdapSetting::distinct('organization_id')->count('organization_id'); return ($numUsedOrgs >= $numOrgs); } public static function listByOrganizationId(int $orgId): Collection { return LdapSetting::where('organization_id', $orgId)->get(); } public static function findByOrganizationId(int $orgId) { return self::listByOrganizationId($orgId)->first(); } public static function findByGroupId(int $groupId) { return LdapSetting::where('groupid', $groupId)->first(); } public static function isGroupUsed(int $groupId): bool { return (null !== self::findByGroupId($groupId)); } } 