<?php
declare(strict_types = 1); namespace App\Models; use Illuminate\Database\Eloquent\Model; use App\Libs\ClusterHelper; class ManagedBookmark extends Model { const NAME_PREFIX = 'BOOKMARK_'; const NAME_MIN = 1; const NAME_MAX = 64; const BOOKMARKS_NUM_MAX = 100; protected $guarded = ['id', 'created_at', 'namebody']; public function chrome_settings() { return $this->belongsToMany(ChromeSetting::class); } public function edge_settings() { return $this->belongsToMany(EdgeSetting::class); } public static function create(array $attributes = []): ManagedBookmark { $masterResult = static::query()->create($attributes); if (ClusterHelper::isCluster()) { $isSlaveOk = false; if (ClusterHelper::isSlaveActive()) { $slaveResult = self::on('slave_database')->create($attributes); if ($slaveResult == null) { $isSlaveOk = false; } elseif ($masterResult->id != $slaveResult->id) { $isSlaveOk = false; } else { $isSlaveOk = true; } } ClusterHelper::updateClusters($masterResult != null, $isSlaveOk); } return $masterResult; } public static function updateBookmarkSetting(array $attributes, int $id): bool { $masterEntity = parent::find($id); if (is_null($masterEntity)) { $isMasterOk = false; } else { $isMasterOk = $masterEntity->fill($attributes)->save(); } if (ClusterHelper::isCluster()) { $isSlaveOk = false; if (ClusterHelper::isSlaveActive()) { $slaveEntity = self::on('slave_database')->find($id); if (is_null($slaveEntity) || $masterEntity->id != $slaveEntity->id) { $isSlaveOk = false; } else { $isSlaveOk = $slaveEntity->fill($attributes)->save(); } } ClusterHelper::updateClusters($isMasterOk, $isSlaveOk); } return $isMasterOk; } public static function destroy($ids): int { $masterCount = parent::destroy($ids); $isMasterOk = $masterCount > 0; if (ClusterHelper::isCluster()) { $isSlaveOk = false; if (ClusterHelper::isSlaveActive()) { $slaveEntities = self::on('slave_database')->whereKey($ids)->get(); if (is_null($slaveEntities)) { $isSlaveOk = false; } else { $slaveCount = 0; foreach ($slaveEntities as $slaveEntity) { if ($slaveEntity->delete()) { $slaveCount++; } } $isSlaveOk = $slaveCount > 0; } } ClusterHelper::updateClusters($isMasterOk, $isSlaveOk); } return $masterCount; } public function getNamebodyAttribute() { return substr($this->name, strlen(self::NAME_PREFIX)) ?: ''; } public function isUsed(): bool { $isUsedByChrome = $this->chrome_settings()->count() > 0; $isUsedByEdge = $this->edge_settings()->count() > 0; return $isUsedByChrome || $isUsedByEdge; } public static function createBookmarkSelectBoxData(array $selectedBookmarks = null): array { $allBookmarks = ManagedBookmark::all(); $options = [ '選択してください' => '' ]; foreach ($allBookmarks as $bookmark) { $options[$bookmark->name] = $bookmark->id; } $optionKeys = array_keys($options); $optionValues = array_values($options); $selectedIndexes = []; if (isset($selectedBookmarks)) { foreach ($selectedBookmarks as $selectedBookmark) { foreach ($optionKeys as $index => $bookmarkName) { if ($selectedBookmark === $bookmarkName) { $selectedIndexes[] = $index; } } } } return [ 'itemTexts' => json_encode($optionKeys), 'itemValues' => json_encode($optionValues), 'initialSelectedItems' => json_encode($selectedIndexes), 'maxShowingSelects' => ManagedBookmark::BOOKMARKS_NUM_MAX, ]; } } 