<?php
 namespace App\Models; use Illuminate\Database\Eloquent\Model; use App\Libs\ClusterHelper as CH; class ProxySetting extends Model { protected $guarded = ['id', 'created_at']; const PROXY_TYPE_SERVER = 1; const PROXY_TYPE_SERVER_STRING = "サーバ指定"; const PROXY_TYPE_SERVER_API_STRING = "server"; const PROXY_TYPE_PAC = 2; const PROXY_TYPE_PAC_STRING = "PACファイル"; const PROXY_TYPE_PAC_API_STRING = "pac"; public function getProxyTypeStringAttribute() { switch ($this->attributes['proxy_type']) { case self::PROXY_TYPE_SERVER: return self::PROXY_TYPE_SERVER_STRING; break; case self::PROXY_TYPE_PAC: return self::PROXY_TYPE_PAC_STRING; break; default: return ""; } } public function getProxyTypeApiStringAttribute() { switch ($this->attributes['proxy_type']) { case self::PROXY_TYPE_SERVER: return self::PROXY_TYPE_SERVER_API_STRING; break; case self::PROXY_TYPE_PAC: return self::PROXY_TYPE_PAC_API_STRING; break; default: return ""; } } public static function create(array $attributes = []) { $setting = static::query()->create($attributes); if (CH::isCluster()) { $slave_setting = null; if (CH::isSlaveActive()) { $slave_setting = self::on('slave_database')->create($attributes); } CH::updateClusters($setting != null, $slave_setting != null); } return $setting; } public static function updateProxySetting($params, $id) { $setting = parent::find($id); $ret = $setting->fill($params)->save(); if (CH::isCluster()) { $s_ret = false; if (CH::isSlaveActive()) { $slave_setting = self::on('slave_database')->find($id); $s_ret = $slave_setting->fill($params)->save(); } CH::updateClusters($ret, $s_ret); } return $ret; } public static function destroy($ids) { $count = parent::destroy($ids); if (CH::isCluster()) { $slave_count = 0; if (CH::isSlaveActive()) { $slave_count = self::on('slave_database')->find($ids)->delete(); } CH::updateClusters($count > 0, $slave_count > 0); } return $count; } public static function getProxySettingNameByID(int $proxy_setting_id): string { if (empty($proxy_setting_id)) { return "なし"; } $proxySetting = self::find($proxy_setting_id); return is_null($proxySetting) ? '' : $proxySetting->name; } public static function getAllProxySettingIDandName() { return self::select('id', 'name')->get(); } } 