<?php
declare(strict_types = 1); namespace App\Models; use Illuminate\Database\Eloquent\Model; use App\Libs\ClusterHelper; class Wallpaper extends Model { const DEFAULT_ID = 0; const DEFAULT_LABEL = "デフォルト"; const INITIAL_STYLE = 'Fit'; const STYLES = [ 'Fill' => 'ページ幅に合わせる', 'Fit' => '画面のサイズに合わせる', 'Stretch' => '拡大して表示', 'Tile' => '並べて表示', 'Center' => '中央に表示', ]; const ACCEPTABLE_MIME_TYPES = [ 'image/jpeg', 'image/bmp', 'image/png', 'image/gif', 'image/tiff', 'image/vnd.ms-photo', 'image/heic', 'image/heif', 'image/heic-sequence', 'image/heif-sequence', 'image/avci', 'image/avcs', 'image/avif', 'image/avif-sequence', ]; protected $fillable = [ 'filename', 'mimetype', 'size', 'style', 'content', ]; public static function create(array $attributes = []): Wallpaper { $masterResult = static::query()->create($attributes); if (ClusterHelper::isCluster()) { $isSlaveOk = false; if (ClusterHelper::isSlaveActive()) { $slaveResult = self::on('slave_database')->create($attributes); if ($slaveResult == null) { $isSlaveOk = false; } elseif ($masterResult->id != $slaveResult->id) { $isSlaveOk = false; } else { $isSlaveOk = true; } } ClusterHelper::updateClusters($masterResult != null, $isSlaveOk); } return $masterResult; } public static function updateWallpaper(array $attributes, int $id): bool { $masterWallpaper = parent::find($id); if (is_null($masterWallpaper)) { $isMasterOk = false; } else { $isMasterOk = $masterWallpaper->fill($attributes)->save(); } if (ClusterHelper::isCluster()) { $isSlaveOk = false; if (ClusterHelper::isSlaveActive()) { $slaveWallpaper = self::on('slave_database')->find($id); if (is_null($slaveWallpaper) || $masterWallpaper->id != $slaveWallpaper->id) { $isSlaveOk = false; } else { $isSlaveOk = $slaveWallpaper->fill($attributes)->save(); } } ClusterHelper::updateClusters($isMasterOk, $isSlaveOk); } return $isMasterOk; } public static function destroy($ids): int { $masterCount = parent::destroy($ids); $isMasterOk = $masterCount > 0; if (ClusterHelper::isCluster()) { $isSlaveOk = false; if (ClusterHelper::isSlaveActive()) { $slaveWallpapers = self::on('slave_database')->whereKey($ids)->get(); if (is_null($slaveWallpapers)) { $isSlaveOk = false; } else { $slaveCount = 0; foreach ($slaveWallpapers as $slaveWallpaper) { if ($slaveWallpaper->delete()) { $slaveCount++; } } $isSlaveOk = $slaveCount > 0; } } ClusterHelper::updateClusters($isMasterOk, $isSlaveOk); } return $masterCount; } public static function getAllSummaries() { return self::select('id', 'filename', 'mimetype', 'size', 'style')->get(); } public static function getAllSummariesWithDefault() { $summaries = self::select('id', 'filename', 'mimetype', 'size', 'style')->get(); $summaries->push(self::getDefault()); return $summaries; } public static function getDefault() { $model = new Wallpaper(); $model->id = self::DEFAULT_ID; $model->filename = self::DEFAULT_LABEL; return $model; } public function isDefault() { return $this->id === self::DEFAULT_ID; } public function getFileUrlAttribute() { return $this->getRouteUrl('wallpaper.file', $this->id); } public function getApiFileUrlAttribute() { return $this->getRouteUrl('api.wallpaper.file', $this->id); } public function getApiJsonUrlAttribute() { return $this->getRouteUrl('api.wallpaper.json', $this->id); } private function getRouteUrl(string $route, int $id) { if ($id === self::DEFAULT_ID) { return null; } else { return route($route, [ 'id' => $id ]); } } } 