<?php
 namespace App\Providers; use Illuminate\Support\ServiceProvider; use Illuminate\Support\Facades\Blade; use DB; use App\Scvuser; use App\Scvgroup; use App\Visionprofile; use App\Revodesktop; use App\Container; use App\Firefoxprofile; use App\Shareprofile; use App\Organization; use App\ScvxChromeSetting; use App\BrSetting; use App\revobr\BrUpdateModule; use App\Libs\ClusterHelper as CH; use App\Libs\ADHelper as ADH; use App\Observers\RevodesktopObserver; class AppServiceProvider extends ServiceProvider { public function boot() { Revodesktop::observe(RevodesktopObserver::class); \Validator::extend('check_alnum', function($attribute, $value, $parameters, $validator){ return preg_match('/^[a-zA-Z0-9_]+$/', $value); }); \Validator::extend('check_alphanum_under_hyphen', function($attribute, $value, $parameters, $validator){ return preg_match('/^[a-zA-Z0-9_-]+$/', $value); }); \Validator::extend('check_share', function($attribute, $value, $parameters, $validator){ return preg_match('#^//.+/.+#', $value); }); \Validator::extend('check_dom', function($attribute, $value, $parameters, $validator){ return preg_match('/^[a-zA-Z0-9]+[a-zA-Z0-9\.\-_]+$/', $value); }); \Validator::extend('pass_rule', function($attribute, $value, $parameters, $validator){ return preg_match('/^[a-zA-Z0-9\!\$\%\-\=\^\~\@\[\{\+\:\*\]\}\,\.\/\?\_\#]+$/', $value); }); \Validator::extend('disable_del', function($attribute, $value, $parameters, $validator){ return $value !== 'scvtemplate'; }); \Validator::extend('exists_user', function($attribute, $value, $parameters, $validator){ $attrs = $validator->attributes(); $org = $attrs['organization']; $user = $attrs['user']; return Scvuser::with_org($org, $user) != null; }); \Validator::extend('group_in_org', function($attribute, $value, $parameters, $validator){ $attrs = $validator->attributes(); if (isset($attrs['new_organization'])) $org = strtoupper($attrs['new_organization']); else $org = strtoupper($attrs['organization']); $group = strtoupper($attrs['group']); return Scvgroup::with_org($org, $group) !== null; }); \Validator::extend('disable_str', function($attribute, $value, $parameters, $validator){ $forbidden = [ 'root', 'daemon', 'bin', 'sys', 'sync', 'games', 'man', 'lp', 'mail', 'news', 'uucp', 'proxy', 'www-data', 'backup', 'list', 'irc', 'gnats', 'nobody', 'libuuid', 'syslog', 'messagebus', 'landscape', 'sshd', 'mysql', 'admin', 'administrator', 'scvadmin', 'scvrun', 'scvcon' ]; $small_val = strtolower($value); return !in_array($small_val, $forbidden, true); }); \Validator::extend('user_in_group', function($attribute, $value, $parameters, $validator){ $attrs = $validator->attributes(); $group = strtoupper($attrs['group']); $name = strtoupper($attrs['name']); return Scvuser::join('scvgroups', 'scvusers.groupid', 'scvgroups.id') ->where('scvgroups.name', $group) ->where('scvusers.name', $name) ->exists(); }); \Validator::extend('user_in_org', function($attribute, $value, $parameters, $validator){ $attrs = $validator->attributes(); $user_name = @$attrs['name'] ?: $attrs['user']; $org = strtoupper($attrs['organization']); $name = strtolower($user_name); $scvuser = Scvuser::with_org($org, $name); return $scvuser !== null; }); \Validator::extend('no_user_in_org', function($attribute, $value, $parameters, $validator){ $attrs = $validator->attributes(); $org = strtoupper($attrs['organization']); $name = strtolower($attrs['name']); $scvuser = Scvuser::with_org($org, $name); return $scvuser === null; }); \Validator::extend('disable_gstr', function($attribute, $value, $parameters, $validator){ $forbidden = array('root','admin','default'); $small_val = strtolower($value); if(in_array($small_val,$forbidden,true)){ return false; }else{ return true; } }); \Validator::extend('hour_vali', function($attribute, $value, $parameters, $validator){ if(strpos($value, ",")){ $hours = explode(",", $value); foreach ($hours as $hour) { if(!preg_match('/^([0-1][0-9]|[2][0-4]):[0-5][0-9]-([0-1][0-9]|[2][0-4]):[0-5][0-9]$/', $hour)){ return false; } } return true; }else{ return preg_match('/^([0-1][0-9]|[2][0-4]):[0-5][0-9]-([0-1][0-9]|[2][0-4]):[0-5][0-9]$/', $value); } }); \Validator::extend('running_user', function($attribute, $value, $parameters, $validator) { $attrs = $validator->attributes(); $org = isset($attrs['organization']) ? $attrs['organization'] : null; $name = isset($attrs['name']) ? $attrs['name'] : null; if ($org === null || $name === null) throw new \Exception('running_userルールを評価するにはorganizationとname属性が必須です。'); $scvuser = Scvuser::with_org($attrs['organization'], $attrs['name']); if ($scvuser === null) return true; $cluster_user = Container::where('username', $name) ->where('organizationname', $org) ->where('containerid', '!=', '') ->get(); if(!$cluster_user->isEmpty()) { return false; } return true; }); \Validator::extend('prof_name_unique', function($attribute, $value, $parameters, $validator){ $ffprof_id = @$validator->getData()['id'] ?: ""; $ffprof_name = 'PROF_'.strtoupper($value); if($ffprof_id){ $exists = Firefoxprofile::where('name',$ffprof_name)->whereNotIn('id',[$ffprof_id])->exists(); return !$exists; }else{ $exists = Firefoxprofile::where('name',$ffprof_name)->exists(); return !$exists; } }); \Validator::extend('using_prof', function($attribute, $value, $parameters, $validator){ $exists = Scvgroup::where('firefoxprofile_id', '=', $value)->exists(); return !$exists; }); \Validator::extend('using_prof_other_org', function($attribute, $value, $parameters, $validator){ $attrs = $validator->attributes(); $prof_org = Firefoxprofile::find($attrs['id'])->organization_id; $input_org = $attrs['organization_id']; $is_using = Scvgroup::where('firefoxprofile_id', '=', $value)->exists(); if ($is_using && ($prof_org != $input_org)) { return false; } return true; }); \Validator::extend('share_name_unique', function($attribute, $value, $parameters, $validator){ $share_name = "SHARE_".strtoupper($value); $share_id = @$validator->getData()['id'] ?: ""; if($share_id){ $exists = Shareprofile::where('shname',$share_name)->whereNotIn('id',[$share_id])->exists(); return !$exists; }else{ $exists = Shareprofile::where('shname',$share_name)->exists(); return !$exists; } }); \Validator::extend('using_share_prof', function($attribute, $value, $parameters, $validator){ $usedByGroup = Scvgroup::where('shareprofile_id', $value)->exists(); $usedByBR = BrSetting::where('shareprofile_id', $value)->exists(); $usedByDT = Visionprofile::where('shareprofile_id', $value)->exists(); return !($usedByGroup || $usedByBR || $usedByDT); }); \Validator::extend('check_hash', function($attribute, $value, $parameters, $validator){ $username = $validator->getData()['username']; $tmpuser = \DB::table('users')->sharedLock()->where('username', $username)->first(); if(\Hash::check($value, $tmpuser->password)){ return true; }else{ return false; } }); \Validator::extend('check_admin', function($attribute, $value, $parameters, $validator){ $small_val = strtolower($value); if($small_val == "admin"){ return false; }else{ return true; } }); \Validator::extend('flow_str', function($attribute, $value, $parameters, $validator){ $valid = preg_match('/^[^\\^\\\\@\\[;:\\],\\/!"#$%&\'()=~|`{+*}<>?　]+$/u', $value); return $valid; }); \Validator::extend('cert_filename', function($attribute, $value, $parameters, $validator){ $fn = $value->getClientOriginalName(); $ret = preg_match('/^[a-zA-Z0-9\s\-=_\(\)\.]*$/', $fn); return $ret; }); \Validator::extend('exist_cert', function($attribute, $value, $parameters, $validator){ $fn = $value->getClientOriginalName(); $profid = $validator->getData()['id']; $fp = Firefoxprofile::find($profid); $path = "/var/www/html/scv/scvtemplates/".$fp->name."/cert/".$fn; return !file_exists($path); }); \Validator::extend('exist_chrome_cert', function($attribute, $value, $parameters, $validator){ $fn = $value->getClientOriginalName(); $profid = $validator->getData()['id']; $scs = ScvxChromeSetting::find($profid); $path = "/var/www/html/scv/scvtemplates/".$scs->name."/cert/".$fn; return !file_exists($path); }); \Validator::extend('validate_otp', function($attribute, $value, $parameters, $validator){ return preg_match('/^[0-9]{3} ?[0-9]{3}$/u', $value); }); \Validator::extend('validate_ip', function($attribute, $value, $parameters, $validator){ if ($value < 0 || $value > 4294967295){ return false; } $str_ip = long2ip($value); if(!$str_ip){ $j_obj->message = "ip convert error"; return false; } return true; }); \Validator::extend('gauth_initialized', function($attribute, $value, $parameters, $validator){ $attrs = $validator->attributes(); $org = isset($attrs['organization']) ? $attrs['organization'] : null; $user = isset($attrs['user']) ? $attrs['user'] : null; $scvuser = Scvuser::with_org($org, $user); return $scvuser->gauth_used != 1; }); \Validator::extend('locked', function($attribute, $value, $parameters, $validator){ $attrs = $validator->attributes(); $org = $attrs['organization']; $user = $attrs['user']; $scvuser = Scvuser::with_org($org, $user); return $scvuser != null ? $scvuser->locked == 0 : false; }); \Validator::extend('client_filename', function($attribute, $value, $parameters, $validator){ $fname = $value->getClientOriginalName(); return preg_match('/RevoBrowser_(\d+\.)+\d+(\-\d+)*.*\.(msi)$/ui', $fname) === 1; }); \Validator::extend('updater_filename', function($attribute, $value, $parameters, $validator){ $fname = $value->getClientOriginalName(); return preg_match('/.*Updater_(\d+\.)+\d+(\-\d+)*.*\.(msi)$/ui', $fname) === 1; }); \Validator::extend('firefox_filename', function($attribute, $value, $parameters, $validator){ $fname = $value->getClientOriginalName(); return preg_match('/firefox_(\d+\.)+\d+(\-\d+)*.*\.(zip)$/ui', $fname) === 1; }); \Validator::extend('chrome_filename', function($attribute, $value, $parameters, $validator){ $fname = $value->getClientOriginalName(); return preg_match('/chrome_(\d+\.)+\d+(\-\d+)*.*\.(zip)$/ui', $fname) === 1; }); \Validator::extend('extension_filename', function($attribute, $value, $parameters, $validator){ $fname = $value->getClientOriginalName(); return preg_match('/Extension_(\d+\.)+\d+(\-\d+)*.*\.(zip)$/ui', $fname) === 1; }); \Validator::extend('module_duplicate', function($attribute, $value, $parameters, $validator){ $fname = $value->getClientOriginalName(); return !BrUpdateModule::where('file_name', $fname)->exists(); }); \Validator::extend('module_specified', function($attribute, $value, $parameters, $validator){ $specified = BrUpdateModule::where('specified', 1)->where('file_name', $value)->exists(); return !$specified; }); \Validator::extend('max_bookmarks', function($attribute, $value, $parameters, $validator){ $max = $parameters[0] ?? 100; $validator->addReplacer('max_bookmarks', function($message, $attribute, $rule, $parameters) use ($max) { return str_replace(':max', $max, $message); }); $bookmarks_array = json_decode($value); return count($bookmarks_array) <= $max; }); \Validator::extend('max_bookmarks_size', function($attribute, $value, $parameters, $validator){ if(strlen($value) > 65535){ return false; } return true; }); \Validator::extend('same_organization', function($attribute, $value, $parameters, $validator){ if (\Auth::user()->organization_id == $value || \Auth::user()->organization_id === 1 ) { return true; } return false; }); \Validator::extend('cidr', function($attribute, $value, $parameters, $validator){ if(strpos($value, '/') === false) return false; list($ip, $mask) = explode('/', $value); if(!filter_var($ip, FILTER_VALIDATE_IP)){ return false; } if($mask < 0 || $mask > 32) return false; return true; }); \Validator::extend('exists_group', function($attribute, $value, $parameters, $validator){ $group = Scvgroup::where('name', strtoupper($value))->exists(); return $group; }); \Validator::extend('ipv4_and_port', function($attribute, $value, $parameters, $validator){ $ret = preg_match('/^(([1-9]?[0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\.){3}([1-9]?[0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5]):([1-9][0-9]{4}|[1-9][0-9]{3}|[1-9][0-9]{2}|[1-9][0-9]{1})$/', $value); return $ret; }); \Validator::extend('using_br_setting', function($attribute, $value, $parameters, $validator){ $exists = Scvgroup::where('br_setting_id', '=', $value)->exists(); return !$exists; }); \Validator::extend('used_vpn_setting', function($attribute, $value, $parameters, $validator){ $existsBr = DB::table('br_setting_vpn_setting')->where('vpn_setting_id', $value)->exists(); $existsDt = DB::table('visionprofile_vpn_setting')->where('vpn_setting_id', $value)->exists(); return !($existsBr || $existsDt); }); \Validator::extend('allowed_hosts', function($attribute, $value, $parameters, $validator){ $value = $this->trimBlankLine($value); $lines = explode(PHP_EOL, $value); foreach ($lines as $line) { $line = trim($line); if (preg_match('/^0.0.0.0/', $line)) { return false; } if (!$this->isIpv4($line) && !$this->isCidr($line)) { return false; } } return true; }); \Validator::extend('using_proxy_setting', function($attribute, $value, $parameters, $validator){ $isUsedByBR = BrSetting::where('proxy_setting_id', '=', $value)->exists(); $isUsedByDT = Visionprofile::where('proxy_setting_id', '=', $value)->exists(); return !($isUsedByBR || $isUsedByDT); }); \Validator::extend('using_chrome_setting', function($attribute, $value, $parameters, $validator){ $exists = BrSetting::where('chrome_setting_id', '=', $value)->exists(); return !$exists; }); \Validator::extend('using_edge_setting', function($attribute, $value, $parameters, $validator){ $exists = BrSetting::where('edge_setting_id', '=', $value)->exists(); return !$exists; }); \Validator::extend('using_scvx_chrome_setting', function($attribute, $value, $parameters, $validator){ $exists = Scvgroup::where('scvx_chrome_setting_id', '=', $value)->exists(); return !$exists; }); \Validator::extend('using_chrome_other_org', function($attribute, $value, $parameters, $validator){ $attrs = $validator->attributes(); $chrome_org = ScvxChromeSetting::find($attrs['id'])->organization_id; $input_org = $attrs['organization_id']; $is_using = Scvgroup::where('scvx_chrome_setting_id', '=', $value)->exists(); if ($is_using && ($chrome_org != $input_org)) { return false; } return true; }); \Validator::extend('using_option', function($attribute, $value, $parameters, $validator){ $attrs = $validator->attributes(); $count = 0; $org = Organization::find($attrs['id']); if ($attribute == 'enable_stz' && $attrs['enable_stz'] != $org->enable_stz) { $count = $org->scvgroups->filter(function ($value) { return ($value->sanitize & 0x40) == 0x40; })->count(); } if ($attribute == 'enable_vck' && $attrs['enable_vck'] != $org->enable_vck) { $count = $org->scvgroups->filter(function ($value) { return ($value->sanitize & 0x80) == 0x80; })->count(); } if ($attribute == 'enable_tck' && $attrs['enable_tck'] != $org->enable_tck) { $count = $org->scvgroups->filter(function ($value) { return ($value->sanitize & 0x100) == 0x100; })->count(); } return $count === 0; }); \Validator::extend('need_enable_pauth', function($attribute, $value, $parameters, $validator){ $pauth_account = $validator->getData()['pauth_account']; return $pauth_account == 1 ? $value == 1 : true; }); \Validator::extend('compare_maxtab', function($attribute, $value, $parameters, $validator) { $attrs = $validator->attributes(); $trim_value = trim($value, ' '); $url_spaces = substr_count($trim_value, ' '); if ($url_spaces+1 > $attrs['max_tab']) { return false; } return true; }); } private function trimBlankLine($value) { $value = rtrim($value); $value = preg_replace('/^\r\n/m', '', $value); return $value; } private function isIpv4($value) { return filter_var($value, FILTER_VALIDATE_IP, FILTER_FLAG_IPV4); } private function isCidr($value) { if (strpos($value, '/') === false) { return false; } $e = explode('/', $value); $ip = $e[0]; $range = $e[1]; if(!$this->isIpv4($ip)){ return false; } if (is_numeric($range) && $range >= 0 && $range <= 32) { return true; } return false; } public function register() { $this->app->singleton(EncryptCookies::class, function(Application $app) { $middleware = new EncryptCookies($app->make(Encrypter::class)); $middleware->disableFor('EXPOSED'); return $middleware; }); $this->app->bind('ScvUserAuthService', 'App\Services\Auth\ScvUserAuthService'); $this->app->bind('ScvUserAuthFactory', 'App\Services\Auth\ScvUserAuthFactory'); } } 