<?php
 namespace App; use Illuminate\Database\Eloquent\Model; use App\Visionprofile; use App\Revodesktop; use App\Libs\RevoDtApps; class Revodesktop extends Model { protected $fillable = ['pcname', 'dtname', 'dtstatus', 'commited_count', 'lastcommited_at', 'installed_apps']; public $timestamps = false; public static function by_pcnameOrFail($pcname) { $pcname = strtolower($pcname); self::validate_pcname_existance($pcname); $revodesktop = self::where('pcname', $pcname)->first(); return $revodesktop; } public static function update_installed_apps_as_json($pcname, $installed_apps) { $pcname = strtolower($pcname); self::validate_pcname_existance($pcname); self::where('pcname', $pcname)->update([ 'installed_apps' => json_encode($installed_apps, JSON_UNESCAPED_UNICODE) ]); } private static function validate_pcname_existance($pcname) { $pcname = strtolower($pcname); $cnt = self::where('pcname', $pcname)->count(); if ($cnt === 0) throw new \Exception("A device record which was named '{$pcname}' is not found."); } public function getUserAttribute() { $scvuser = Scvuser::find($this->uid); if ($scvuser === null) return 'unknown'; return $scvuser->organization . '/' . $scvuser->name; } public function getDtstatusNameAttribute() { switch ($this->dtstatus) { case 1: return 'INIT'; case 2: return 'READY'; case 3: return 'USING'; case 4: return 'DELETED'; default: return 'unknown'; } } public function getInstalledAppArrayAttribute() { $installed_apps = json_decode($this->installed_apps); if (empty($installed_apps)) { return []; } else if (count($installed_apps) == 0) { return []; } $arr = []; foreach ($installed_apps as $installed_app) $arr[] = $installed_app->name; return $arr; } public function getAvailableAppArrayAttribute() { $installed_apps = $this->installed_app_array; $dt = Visionprofile::where('name', '=', $this->dtname)->first(); if($installed_apps === [] || !$dt){ return []; }else{ return RevoDtApps::by_dtname($this->dtname) ->get_available_apps($installed_apps); } } public function getInstalledAppsCommaAttribute() { return implode(',', $this->installed_app_array); } public function getAvailableAppsCommaAttribute() { return implode(',', $this->available_app_array); } } 