<?php
 namespace App; use Illuminate\Database\Eloquent\Model; use App\Http\Requests; use Config; use Mail; use DB; use Carbon\Carbon; use App\Scvuser; use App\Scvgroup; use App\Filelog; use App\ScvflowLog; use Illuminate\Support\Facades\Auth; use App\Jobs\SendReminderEmail; use App\Libs\ConfHelper; class Scvflow extends Model { use \App\Traits\ScvFlowCtrl; protected $guarded = ['id']; public $timestamps = false; private static $requests_memo = []; protected static function boot() { parent::boot(); self::updated(function($request) { $dl_key = $request->dl_key; unset(self::$requests_memo[$dl_key]); }); } public static function is_available() { return (int)!!ConfHelper::scvconf('SCV_FLOW'); } public static function umax_bytes() { $mb = ConfHelper::scvconf('SCV_FLOW_UMAX'); if ($mb === null) return 0; else return 1024 * 1024 * $mb; } public static function get_save_dir() { return base_path('_scvflow/uploads'); } public static function original_filepath($dl_key) { return self::get_save_dir() . '/' . $dl_key; } public static function get_dl_url($dl_key, $host_url = null) { return self::make_url("scvflow/download/{$dl_key}", $host_url); } public static function get_preview_url($dl_key, $host_url = null) { return self::make_url("scvflow/download/preview/{$dl_key}", $host_url); } public static function get_auth_url($dl_key, $host_url = null) { return self::make_url("scvflow/auth/{$dl_key}", $host_url); } private static function make_url($path, $host_url = null) { if ($host_url === null) $host_url = url('/'); return "{$host_url}/{$path}"; } public static function generate_dl_key() { static $chars = 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJLKMNOPQRSTUVWXYZ0123456789'; $char_len = strlen($chars) - 1; $key_len = 12; do { for ($i = 0, $dl_key = ''; $i < $key_len; ++$i) $dl_key .= $chars[mt_rand(0, $char_len)]; } while (self::where('dl_key', $dl_key)->count()); return $dl_key; } public static function dl_response($dl_key, $mime = '') { $request = self::get_request($dl_key); $filename = $request->filename; $filepath = self::original_filepath($dl_key); $disp_pattern = [ 'Content-Disposition: attachment; filename*=UTF-8\'\'' . rawurlencode($filename) . '"', 'Content-Disposition: attachment; filename*=UTF-8\'\'"' . rawurlencode($filename) . '"', 'Content-Disposition: attachment; filename*=UTF-8\'\'' . rawurlencode($filename) . ';', 'Content-Disposition: attachment; filename*=UTF-8\'\'"' . rawurlencode($filename) . '";', ]; $select_ptn = 2; header('Accept-Ranges: bytes'); if ($mime === '') header('Content-Type: application/octet-stream'); else header('Content-Type: ' . $mime); header($disp_pattern[$select_ptn]); header('Content-Length: ' . filesize($filepath)); readfile($filepath); } public static function get_request($dl_key) { if (!array_key_exists($dl_key, self::$requests_memo)) { $request = self::get_requests_where(1, 'dl_key', $dl_key, '', '', '', '', '', false)->first(); self::$requests_memo[$dl_key] = $request; } return self::$requests_memo[$dl_key]; } public static function get_expired_requests() { $days = ConfHelper::scvconf('SCV_FLOW_KEEPDAYS'); if ($days === null) return null; $days = (int)$days; if ($days <= 0) return null; $start_date = '1999-01-01 00:00:00'; $end_date = Carbon::now()->modify("-{$days} day")->format('Y-m-d H:i:s'); return self::whereBetween('requested_at', [$start_date, $end_date])->get(); } public static function get_requests_to_authorizer($limit, $authorizer_id, $start_date = '', $end_date = '', $status = '', $keyword = '', $sort = 'desc', $paginate = true) { return self::get_requests_where($limit, 'fa.authorizer_id', $authorizer_id, $start_date, $end_date, $status, $keyword, $sort, $paginate); } public static function get_requests_from_applicant($limit, $applicant_id, $start_date = '', $end_date = '', $status = '', $keyword = '', $sort = 'desc', $paginate = true) { return self::get_requests_where($limit, 'applicant_id', $applicant_id, $start_date, $end_date, $status, $keyword, $sort, $paginate); } private static function get_requests_where($limit, $column, $value, $start_date = '', $end_date = '', $status = '', $keyword = '', $sort, $paginate = true) { $query = self::join('scvusers as u1', 'scvflows.applicant_id', '=', 'u1.id') ->leftjoin('flowauthorizers as fa', 'scvflows.id', '=', 'fa.flow_id') ->join('scvusers as u2', 'fa.authorizer_id', '=', 'u2.id') ->groupBy('scvflows.id'); if ($column !== null && $value !== null) $query->where($column, $value); if ($start_date && $end_date) $query->whereBetween('requested_at', [$start_date, $end_date]); if ($status) $query->where('status', $status); if ($keyword) { $query->where(function($query) use($keyword) { $query->where('scvflows.filename', 'like', "%{$keyword}%"); $query->orWhere('scvflows.comment', 'like', "%{$keyword}%"); $query->orWhere('scvflows.dl_key', 'like', "%{$keyword}%"); $query->orWhere('scvflows.why_denied', 'like', "%{$keyword}%"); $query->orWhere('u1.jpname', 'like', "%{$keyword}%"); $query->orWhere('u2.jpname', 'like', "%{$keyword}%"); $query->orWhere('u1.department', 'like', "%{$keyword}%"); $query->orWhere('u2.department', 'like', "%{$keyword}%"); $query->orWhere('u1.post', 'like', "%{$keyword}%"); $query->orWhere('u2.post', 'like', "%{$keyword}%"); $query->orWhere('u1.employee_id', 'like', "%{$keyword}%"); $query->orWhere('u2.employee_id', 'like', "%{$keyword}%"); }); } $query->select( 'scvflows.*', 'u1.id as applicant_id', 'u2.id as authorizer_id', 'u1.name as applicant_name', 'u2.name as authorizer_name', 'u1.email as applicant_email', 'u2.email as authorizer_email', 'u1.jpname as applicant_jpname', 'u2.jpname as authorizer_jpname', 'u1.department as applicant_department', 'u2.department as authorizer_department', 'u1.post as applicant_post', 'u2.post as authorizer_post', 'u1.employee_id as applicant_employee_id', 'u2.employee_id as authorizer_employee_id' ); $sort = mb_strtolower($sort); if ($sort !== 'asc' && $sort !== 'desc') $sort = 'desc'; $query->orderBy('scvflows.requested_at', $sort) ->orderBy('scvflows.id', $sort); if ($paginate) return $query->paginate($limit); else return $query->limit($limit)->get(); } public static function next_url($dl_key) { return self::neighbor_url($dl_key, true); } public static function prev_url($dl_key) { return self::neighbor_url($dl_key, false); } private static function neighbor_url($dl_key, $next_flg) { $ineq = $next_flg ? '>' : '<'; $order = $next_flg ? 'asc' : 'desc'; $login_user = Auth::guard('scvuser')->user(); if ($login_user === null) return ''; $current_request = self::get_request($dl_key); if ($current_request === null) return ''; $prev_request = self::join('flowauthorizers as fa', 'scvflows.id', '=', 'fa.flow_id') ->where('fa.authorizer_id', $login_user->id) ->where('scvflows.id', $ineq, $current_request->id) ->orderBy('scvflows.id', $order) ->limit(1) ->first(); if ($prev_request === null) return ''; return self::get_auth_url($prev_request->dl_key); } public static function cancel_request($dl_key, &$okmsg, &$errmsg) { $okmsg = ''; $request = self::get_request($dl_key); if ($request === null) { $errmsg = '申請が存在しません'; return false; } else if ($request->status !== 'waiting') { $errmsg = '承認待ちの申請のみ取り消しができます'; return false; } else { $okmsg = '申請を取り消しました'; $errmsg = ''; self::delete_original_file($dl_key); ScvflowLog::where('dl_key', $dl_key)->update(['status' => 'canceled']); return self::where('dl_key', $dl_key)->delete(); } } public static function bulk_cancel_requests($dl_keys, &$okmsg, &$errmsgs) { $okcnt = 0; $errmsgs = []; foreach ($dl_keys as $dl_key) { if (self::cancel_request($dl_key, $okmsg, $errmsg)) { ++$okcnt; } else { $request = self::get_request($dl_key); $errmsgs[] = "{$request->filename}: {$errmsg}"; } } if ($okcnt > 0) $okmsg = "{$okcnt}件の申請を取り消しました"; else $okmsg = ''; } public static function permit_request($authorizer, $dl_key, $reason, $replace_file, &$msg, $mail_notice = true) { return self::authorize_request($authorizer, $dl_key, true, $reason, $replace_file, $msg, $mail_notice); } public static function bulk_permit_requests($authorizer, $dl_keys, $reason, &$okmsg, &$errmsgs, $mail_notice = true) { $okcnt = 0; $errmsgs = []; foreach ($dl_keys as $dl_key) { if (self::permit_request($authorizer, $dl_key, $reason, null, $msg, $mail_notice)) { ++$okcnt; } else { $request = self::get_request($dl_key); $errmsgs[] = "{$request->filename}: {$msg}"; } } if ($okcnt > 0) $okmsg = "{$okcnt}件の申請を承認しました"; else $okmsg = ''; } public static function deny_request($authorizer, $dl_key, $reason, &$msg, $mail_notice = true) { return self::authorize_request($authorizer, $dl_key, false, $reason, null, $msg, $mail_notice); } public static function bulk_deny_requests($authorizer, $dl_keys, $reason, &$okmsg, &$errmsgs, $mail_notice = true) { $okcnt = 0; $errmsgs = []; foreach ($dl_keys as $dl_key) { if (self::deny_request($authorizer, $dl_key, $reason, $msg, $mail_notice)) { ++$okcnt; } else { $request = self::get_request($dl_key); $errmsgs[] = "{$request->filename}: {$msg}"; } } if ($okcnt > 0) $okmsg = "{$okcnt}件の申請を否認しました"; else $okmsg = ''; } public static function is_confirmed($dl_key) { $request = self::get_request($dl_key); return !!$request->confirmed; } public static function confirm_request($dl_key) { $request = self::get_request($dl_key); if ($request !== null) { $request = self::find($request->id); $request->confirmed = 1; $request->save(); } } private static function authorize_request($authorizer, $dl_key, $permit_flag, $reason, $replace_file, &$msg, $mail_notice) { $request = self::get_request($dl_key); if ($request === null) { $msg = '申請データが見つかりませんでした'; return false; } $applicant = Scvuser::find($request->applicant_id); $authorizers_id = FlowAuthorizer::getAuthorizersByFlowId($request->id); $match = 0; foreach($authorizers_id as $authorizer_id) { if ($authorizer->id == $authorizer_id) { $match++; } } if (!$match) { $msg = '指定された承認者とは異なるユーザがファイルを承認しようとしました'; return false; } if ($request->status === 'permitted') { $msg = '既に承認済みのファイルです'; return false; } if ($request->status === 'denied') { $msg = '既に否認済みのファイルです'; return false; } if ($permit_flag && !self::is_confirmed($dl_key)) { $msg = '申請ファイルを未確認のため、承認処理が取り消されました'; return false; } $filename = $request->filename; if ($permit_flag && $replace_file !== null) { try { if (!self::is_confirmed($dl_key)) throw new \Exceptipon('申請ファイルを未確認のため、承認処理は取り消されました'); self::replace_file($dl_key, $replace_file); $filename = $replace_file->getClientOriginalName(); } catch (\Exception $e) { $msg = $e->getMessage(); return false; } } $status = $permit_flag ? 'permitted' : 'denied'; $authorized_at = date('Y-m-d H:i:s'); $request->status = $status; $request->why_denied = $reason; $request->authorized_at = $authorized_at; $request->authorizer_id = $authorizer->id; $request->save(); if (!$permit_flag) self::delete_original_file($dl_key); if ($applicant === null) logger('申請者がすでに存在しないため、結果通知メールの送信は取り消されました'); else { $host_url = url('/'); dispatch(new SendReminderEmail( 'authorized', $request->action_type, $dl_key, $host_url, $status, $filename, $reason, $authorized_at, $authorizer->id )); } self::rewrite_log($dl_key, $filename, $status, $reason, $authorized_at); $msg = '申請を' . ($permit_flag ? '承認' : '否認') . 'しました'; return true; } private static function replace_file($dl_key, $file) { $rewrite_on = ConfHelper::scvconf('SCV_FLOW_REWRITE'); if ($rewrite_on !== '1') throw new \Exception('申請ファイルの差し替えは無効になっています'); if ($file === null || !$file->isValid()) throw new \Exception('ファイルの送信に失敗しました。'); switch (self::get_request($dl_key)->action_type) { case 'upload': $max_bytes = Scvflow::umax_bytes(); if ($max_bytes > 0 && $file->getSize() > $max_bytes) throw new \Exception('ファイルサイズが制限を超過しています。'); break; case 'download': $max_bytes = ConfHelper::getFlowDMAX() * 1024 * 1024; if ($max_bytes > 0 && $file->getSize() > $max_bytes) throw new \Exception('ファイルサイズが制限を超過しています。'); break; } Scvflow::delete_original_file($dl_key); $save_dir = Scvflow::get_save_dir(); $filename = $file->getClientOriginalName(); if (!$file->move($save_dir, $dl_key)) throw new \Exception('サーバ内でのファイルの移動に失敗しました。'); $request = Scvflow::where('dl_key', $dl_key)->first(); $request->filename = $filename; $request->filesize = $file->getClientSize(); $request->save(); } public static function write_log($dl_key, $applicant_ip, $action_type) { $request = self::get_request($dl_key); $applicant = Scvuser::find($request->applicant_id); if ($applicant === null) { throw new \Exception('ログの新規書き込み時に申請者を取得できませんでした。'); } $authorizer = Scvuser::find($request->authorizer_id); if ($authorizer === null) { throw new \Exception('ログの新規書き込み時に承認者を取得できませんでした。'); } $org_name = Organization::get_name_by_groupid($applicant->groupid); $request = ScvflowLog::create([ 'dl_key' => $request->dl_key, 'action_type' => $action_type, 'filename' => $request->filename, 'filesize' => $request->filesize, 'comment' => $request->comment, 'organization' => $org_name, 'applicant_user' => $applicant->name, 'applicant_summary' => $request->applicant_summary, 'applicant_ip' => $applicant_ip, 'authorizer_user' => $authorizer->name, 'authorizer_summary' => $request->authorizer_summary, 'why_denied' => $request->why_denied, 'replaced_filename' => $request->replaced_filename, 'status' => $request->status, 'requested_at' => $request->requested_at, 'authorized_at' => $request->authorized_at ]); Filelog::create([ 'operation' => 'FLOW_'. strtoupper($action_type), 'scvflow_id' => $request->id ]); } private static function rewrite_log($dl_key, $filename, $status, $reason, $authorized_at) { ScvflowLog::where('dl_key', $dl_key)->update([ 'filename' => $filename, 'status' => $status, 'why_denied' => $reason, 'authorized_at' => $authorized_at ]); } private static function delete_log($dl_key) { $request = self::get_request($dl_key); $cnt = Filelog::where('scvflow_id', $request->id)->delete(); $cnt += ScvflowLog::where('dl_key', $dl_key)->delete(); return $cnt > 0; } public static function delete_original_file($dl_key) { $file = self::original_filepath($dl_key); if (!file_exists($file)) { logger("SCV_Flow：scvflows.dl_key= {$dl_key} の原本ファイルの削除に失敗しました"); return; } else { if (env('APP_DEBUG')) logger("SCV_Flow：scvflows.dl_key= {$dl_key} の原本ファイルが削除されました"); } unlink($file); } public static function delete_expired_requests() { $requests = self::get_expired_requests(); if (!$requests->count()) return 0; foreach ($requests as $request) { if ($request->status !== 'denied') self::delete_original_file($request->dl_key); $request->delete(); FlowAuthorizer::where('flow_id', $request->id)->delete(); } $cnt = $requests->count(); logger("SCV Flow：期限切れによる{$cnt}件の申請を削除しました。"); return $cnt; } public function getJpstatusAttribute() { switch ($this->status) { case 'canceled': return '申請取消'; case 'waiting': return '承認待ち'; case 'permitted': return '承認済み'; case 'denied': return '否認済み'; default: return '異常値'; } } public function getJpoperationAttribute() { switch ($this->status) { case 'canceled': return '取消'; case 'waiting': return '申請'; case 'permitted': return '承認'; case 'denied': return '否認'; default: return '異常値'; } } public function getJpactiontypeAttribute() { switch ($this->action_type) { case 'upload': return 'アップロード'; case 'download': return 'ダウンロード'; default: return '不明'; } } public function getOrganizationAttribute() { $applicant = Scvuser::find($this->applicant_id); $authorizer = Scvuser::find($this->authorizer_id); if ($applicant) return $applicant->organization; else if ($authorizer) return $authorizer->organization; else return '（取得不可）'; } public function getApplicantSummaryAttribute() { $scvuser = Scvuser::find($this->applicant_id); if ($scvuser === null) return '（存在しないユーザ）'; return sprintf('%s：%s', $scvuser->department, $scvuser->jpname); } public function getAuthorizersOverallSummaryAttribute() { $authorizers = ""; $scvusers = FlowAuthorizer::leftjoin('scvusers as u1', 'flowauthorizers.authorizer_id', '=' ,'u1.id') ->select( DB::Raw('CONCAT(u1.department, ":", u1.jpname) as summary') ) ->where('flowauthorizers.flow_id', '=', $this->id) ->pluck('summary'); $length = count($scvusers); $no = 0; foreach ($scvusers as $scvuser) { if (empty($scvuser)) { $scvuser = "存在しないユーザ"; } $authorizers .= $scvuser; if(++$no !== $length) { $authorizers .= "\n"; } } return $authorizers; } public function getAuthorizersMailformatAttribute() { $authorizers = ""; $scvusers = FlowAuthorizer::leftjoin('scvusers as u1', 'flowauthorizers.authorizer_id', '=' ,'u1.id') ->select( DB::Raw('CONCAT(u1.department, ":", u1.jpname) as summary') ) ->where('flowauthorizers.flow_id', '=', $this->id) ->pluck('summary'); $length = count($scvusers); $no = 0; foreach ($scvusers as $scvuser) { if (empty($scvuser)) { $scvuser = "存在しないユーザ"; } $authorizers .= $scvuser; if(++$no !== $length) { $authorizers .= ","; } } return $authorizers; } public function getAuthorizerSummaryAttribute() { $scvuser = Scvuser::find($this->authorizer_id); if ($scvuser === null) return '（存在しないユーザ）'; return sprintf('%s：%s', $scvuser->department, $scvuser->jpname); } public static function getDownloadableFileListWithOrg($org_name, $username, $action_type) { if (empty($org_name)) { $return_data = array( "status" => 'error', "message" => "組織名の値が渡されていません。" ); return json_encode($return_data); } if (empty($username)) { $return_data = array( "status" => 'error', "message" => "ユーザ名の値が渡されていません。" ); return json_encode($return_data); } if (empty($action_type)) { $return_data = array( "status" => 'error', "message" => "申請種別の値が渡されていません。" ); return json_encode($return_data); } $scvuser = Scvuser::with_org($org_name, $username); if($scvuser == null) { $return_data = array( "status" => 'error', "message" => "ユーザが見つかりませんでした。" ); return json_encode($return_data); } $status = ''; $message = ''; $file_list = Scvflow::select('id', 'filename') ->where([ ['applicant_id', '=', $scvuser->id], ['status', '=', 'permitted'], ['action_type', '=', $action_type] ])->get(); if ($file_list->isEmpty()) { $status = 'success'; $message = 'empty'; } else if ($file_list->count() > 0) { $status = 'success'; $message = $file_list->count().'件見つかりました。'; } else { $status = 'ng'; $message = 'error'; } $return_data = array( "status" => $status, "message" => $message, "files" => $file_list ); return json_encode($return_data); } public static function getDownloadableFileList($applicant_id, $action_type) { if (empty($applicant_id)) { $return_data = array( "status" => 'error', "message" => "申請者IDの値が渡されていません。" ); return json_encode($return_data); } if (empty($action_type)) { $return_data = array( "status" => 'error', "message" => "申請種別の値が渡されていません。" ); return json_encode($return_data); } $status = ''; $message = ''; $file_list = Scvflow::select('id', 'filename') ->where([ ['applicant_id', '=', $applicant_id], ['status', '=', 'permitted'], ['action_type', '=', $action_type] ])->get(); if ($file_list->isEmpty()) { $status = 'success'; $message = 'empty'; } else if ($file_list->count() > 0) { $status = 'success'; $message = $file_list->count().'件見つかりました。'; } else { $status = 'ng'; $message = 'error'; } $return_data = array( "status" => $status, "message" => $message, "files" => $file_list ); return json_encode($return_data); } public static function getDownloadableFileListAll($applicant_id) { if (empty($applicant_id)) { $return_data = array( "status" => 'error', "message" => "申請者IDの値が渡されていません。" ); return json_encode($return_data); } $status = ''; $message = ''; $file_list = Scvflow::select('id', 'filename') ->where([ ['applicant_id', '=', $applicant_id], ['status', '=', 'permitted'] ])->get(); if ($file_list->isEmpty()) { $status = 'success'; $message = 'empty'; } else if ($file_list->count() > 0) { $status = 'success'; $message = $file_list->count().'件見つかりました。'; } else { $status = 'ng'; $message = 'error'; } $return_data = array( "status" => $status, "message" => $message, "files" => $file_list ); return json_encode($return_data); } public static function getDownloadfile($id) { $target_file_key = Scvflow::find($id); return Scvflow::dl_response($target_file_key->dl_key); } public static function getFlowRequestById($id) { return Scvflow::find($id); } public static function isDownloadableByGroupId($group_id) { if (empty($group_id)) { return false; } $scvflow_status = Scvgroup::find($group_id)->scv_flow; if($scvflow_status > 1 ) { return true; } return false; } } 