<?php
 namespace App; use Illuminate\Auth\Authenticatable; use Illuminate\Database\Eloquent\Model; use Illuminate\Auth\Passwords\CanResetPassword; use Illuminate\Contracts\Auth\Authenticatable as AuthenticatableContract; use Illuminate\Contracts\Auth\CanResetPassword as CanResetPasswordContract; use App\Firefoxprofile; use App\ScvxChromeSetting; use App\Shareprofile; use App\BrSetting; use App\Libs\UserHelper; use App\Libs\ClusterHelper as CH; use Illuminate\Support\Collection; class Scvgroup extends Model implements AuthenticatableContract, CanResetPasswordContract { use Authenticatable, CanResetPassword; protected $table = 'scvgroups'; protected $guarded = ['id']; public static function get_fields($without_fields = []) { $fields = \Schema::getColumnListing('scvgroups'); foreach ($without_fields as $without_field) { $index = array_search($without_field, $fields); if ($index === false) continue; unset($fields[$index]); } $fields = array_values($fields); return $fields; } public function ldapSetting() { return $this->hasOne(LdapSetting::class, 'groupid'); } public function firefoxprofile() { return $this->belongsTo(Firefoxprofile::class); } public function chromeSetting() { return $this->belongsTo(ScvxChromeSetting::class); } public function brSetting() { return $this->belongsTo(BrSetting::class); } public static function with_org($org_name, $group_name) { return Scvgroup::join('organizations', 'scvgroups.organization_id', 'organizations.id') ->where('organizations.name', $org_name) ->where('scvgroups.name', $group_name) ->select( 'scvgroups.*', 'scvgroups.id as group_id' ) ->first(); } public function getOrganizationAttribute() { return Organization::get_name_by_groupid($this->id); } public function getOrgGroupAttribute() { $org_name = Organization::get_name_by_groupid($this->id); return "{$org_name}/{$this->name}"; } public function getDisplayNameAttribute() { if (UserHelper::isAdmin()) return $this->getOrgGroupAttribute(); else return $this->name; } public function getFirefoxprofileNameAttribute() { if ($this->firefoxprofile_id === 0) return ''; return Firefoxprofile::find($this->firefoxprofile_id)->name; } public function getScvxchromesettingNameAttribute() { if ($this->scvx_chrome_setting_id === 0) return ''; return ScvxChromeSetting::find($this->scvx_chrome_setting_id)->name; } public function getShareprofileNameAttribute() { if ($this->shareprofile_id === 0) return ''; return Shareprofile::find($this->shareprofile_id)->shname; } public function getCopypasteViewAttribute() { $flg = $this->copypaste; $opts = self::get_copypaste_options(); $opt = isset($opts[$flg]) ? $opts[$flg] : $opts[0]; return $opt; } public static function get_copypaste_options() { return ['無効', '上下有効', '上り有効', '下り有効']; } public static function getGroupByUserAndOrg($org, $user) { $user = Scvuser::with_org($org, $user); return self::find($user->groupid); } public static function listGroupsByOrgId(int $orgId): Collection { return Scvgroup::where('organization_id', $orgId)->get(); } public static function orgInScvtemplateExists($organization_id) { return Scvgroup::where('organization_id', '=', $organization_id) ->where('name', '=', 'SCVTEMPLATE') ->exists(); } public static function deleteScvtemplate($organization_id) { $scvgroups = Scvgroup::listGroupsByOrgId($organization_id); if($scvgroups->count() > 1) { return ; } $scvgroup = Scvgroup::where('organization_id', '=', $organization_id)->first(); $count = $scvgroup->delete(); if (CH::isCluster()) { $slave_count = 0; if (CH::isSlaveActive()) { $slave_count = self::on('slave_database')->find($scvgroup->id)->delete(); } CH::updateClusters($count > 0, $slave_count > 0); } return $count; } public static function getScvgroupRegisteredFirefoxprof() { return Scvgroup::whereNotIn('firefoxprofile_id', [0])->get(); } public static function getScvgroupRegisteredShareprofile() { return Scvgroup::whereNotIn('shareprofile_id', [0])->get(); } } 