<?php
 namespace App; use Illuminate\Auth\Authenticatable as Authenticatable_trait; use Tymon\JWTAuth\Contracts\JWTSubject; use Illuminate\Foundation\Auth\User as Authenticatable; use Illuminate\Auth\Passwords\CanResetPassword; use Illuminate\Contracts\Auth\Authenticatable as AuthenticatableContract; use Illuminate\Contracts\Auth\CanResetPassword as CanResetPasswordContract; use Illuminate\Support\Facades\Hash; use App\Scvgroup; use App\Libs\ClusterHelper as CH; use Illuminate\Support\Collection; class Scvuser extends Authenticatable implements AuthenticatableContract, CanResetPasswordContract, JWTSubject { use Authenticatable_trait, CanResetPassword; const SYSTEM_USERS = [ 'scvtemplate' ]; protected $table = 'scvusers'; protected $fillable = ['name', 'groupid']; protected $hidden = ['password', 'remember_token']; public function scvgroup() { return $this->belongsTo('App\Scvgroup', 'groupid'); } public function getJWTIdentifier() { return $this->getKey(); } public function getJWTCustomClaims() { return []; } public static function is_locked($org, $user) { return self::with_org($org, $user)->locked; } public static function get_fields($without_fields = []) { $fields = \Schema::getColumnListing('scvusers'); foreach ($without_fields as $without_field) { $index = array_search($without_field, $fields); if ($index === false) continue; unset($fields[$index]); } $fields = array_values($fields); return $fields; } public static function all_permitted($user) { $query = self::leftjoin('scvgroups', 'scvusers.groupid', 'scvgroups.id') ->leftjoin('organizations', 'scvgroups.organization_id', 'organizations.id'); $org = Organization::find($user->organization_id); if ($org->name !== 'ADMIN') $query->where('organizations.id', $org->id); $query->whereNotIn('scvusers.name', self::SYSTEM_USERS); return $query->select('scvusers.*')->get(); } public static function get_name($id) { $scvuser = self::where('id', $id)->select('name')->first(); return $scvuser === null ? null : $scvuser->name; } public static function get_jpname($id) { $scvuser = self::where('id', $id)->select('jpname')->first(); return $scvuser === null ? null : $scvuser->jpname; } public static function get_id($name) { $scvuser = self::where('name', $name)->select('id')->first(); return $scvuser === null ? null : $scvuser->id; } public static function by_name($name) { return self::where('name', $name)->first(); } public static function with_org($org_name, $user_name) { $scvuser = self::join('scvgroups', 'scvusers.groupid', 'scvgroups.id') ->join('organizations', 'scvgroups.organization_id', 'organizations.id') ->where('scvusers.name', $user_name) ->where('organizations.name', $org_name) ->select('scvusers.id as user_id') ->first(); if ($scvuser === null) return null; return self::find($scvuser->user_id); } public static function with_org_count($org_name, $user_name) { return Scvuser::join('scvgroups', 'scvusers.groupid', '=', 'scvgroups.id') ->join('organizations', 'scvgroups.organization_id', '=', 'organizations.id') ->where('scvusers.name', $user_name) ->where('organizations.name', $org_name) ->select('scvusers.id') ->count(); } public static function get_prof_name($uid) { return @Scvuser::select('*', 'scvusers.id as uid', 'firefoxprofiles.name as prof_name') ->leftJoin('scvgroups', 'scvgroups.id', 'scvusers.groupid') ->leftJoin('firefoxprofiles', 'firefoxprofiles.id', 'scvgroups.firefoxprofile_id') ->where('scvusers.id', $uid) ->first()->prof_name; } public static function toOrgUser(string $username): array { $prms = explode('/', $username); if (count($prms) === 1) { $org = 'ADMIN'; $user = $prms[0]; } else { $org = strtoupper($prms[0]); $user = $prms[1]; } return [$org, $user]; } public static function by_logintxt($username) { list($org, $user) = self::toOrgUser($username); return self::with_org($org, $user); } private static function resetPwdFailCount($scvuser) { if($scvuser->pwd_fail_count == 0){ return $scvuser; } $scvuser->pwd_fail_count = 0; $dbret = $scvuser->save(); if(CH::isCluster()){ $slave_dbret = false; if(CH::isMaster() && CH::isSlaveActive()){ $slave_scvuser_model = new Scvuser; $slave_scvuser_model->setConnection('slave_database'); $slave_scvuser = $slave_scvuser_model->find($scvuser->id); $slave_scvuser->pwd_fail_count = 0; $slave_dbret = $slave_scvuser->save(); }else if(CH::isSlave()){ $slave_dbret = $dbret; $dbret = false; } CH::updateClusters($dbret, $slave_dbret); } return $scvuser; } public static function incrementPwdFailCount($username, $scvuser) { $a = explode('/', $username); $org = Organization::where('name', '=', $a[0])->first(); if ($org == null) { $org = Organization::where('name', 'ADMIN')->first(); } if($org->lockout_threshold == 0){ return $scvuser; } $scvuser->pwd_fail_count += 1; if($scvuser->pwd_fail_count > $org->lockout_threshold){ $scvuser->locked = true; } $dbret = $scvuser->save(); if(CH::isCluster()){ $slave_dbret = false; if(CH::isMaster() && CH::isSlaveActive()){ $slave_scvuser_model = new Scvuser; $slave_scvuser_model->setConnection('slave_database'); $slave_scvuser = $slave_scvuser_model->find($scvuser->id); $slave_scvuser->pwd_fail_count = $scvuser->pwd_fail_count; $slave_scvuser->locked = $scvuser->locked; $slave_dbret = $slave_scvuser->save(); }else if(CH::isSlave()){ $slave_dbret = $dbret; $dbret = false; } CH::updateClusters($dbret, $slave_dbret); } return $scvuser; } public static function attemptScvLogin($username, $password) { $scvuser = self::by_logintxt($username); if ($scvuser !== null && Hash::check($password, $scvuser->password)){ $scvuser = self::resetPwdFailCount($scvuser); $scvuser->login_success = true; return $scvuser; }else if($scvuser !== null){ $scvuser = self::incrementPwdFailCount($username, $scvuser); $scvuser->login_success = false; return $scvuser; }else{ return null; } } public static function update_ff_timemill($id){ $user = self::find($id); $user->ff_timemill = floor(microtime(true) * 1000); return $user->save(); } public function getOrganizationAttribute() { return Organization::get_name_by_groupid($this->groupid); } public function getGroupAttribute() { return Scvgroup::find($this->groupid)->name; } public function getOrgGroupAttribute() { $org_name = Organization::get_name_by_groupid($this->groupid); $group_name = Scvgroup::find($this->groupid)->name; return "{$org_name}/{$group_name}"; } public static function getFlowAuthorizers($scvuser) { $org_name = Organization::get_name_by_groupid($scvuser->groupid); $query = Scvuser::join('scvgroups', 'scvusers.groupid', 'scvgroups.id') ->join('organizations', 'scvgroups.organization_id', 'organizations.id') ->where('organizations.name', $org_name) ->where('scvusers.privilege', 1) ->where('scvusers.name', '!=', $scvuser->name); if ($scvuser->flow_group) { $query->where(function($query) use($scvuser) { $query->where('scvusers.flow_group', $scvuser->flow_group) ->orWhere('scvusers.flow_group', ''); }); } $scvusers = $query->select( 'scvusers.id', 'scvusers.name', 'scvusers.jpname', 'scvusers.department', 'scvusers.post', 'scvusers.employee_id', 'scvusers.custom_data1', 'scvusers.custom_data2', 'scvusers.custom_data3' ) ->get(); if (!count($scvusers)) { return ""; } $authorizers = []; foreach ($scvusers as $scvuser) { $authorizers[] = [ 'id' => $scvuser->id, 'name' => $scvuser->name, 'jpname' => $scvuser->jpname, 'department' => $scvuser->department, 'post' => $scvuser->post, 'employee_id' => $scvuser->employee_id, 'custom_data1' => $scvuser->custom_data1, 'custom_data2' => $scvuser->custom_data2, 'custom_data3' => $scvuser->custom_data3 ]; } return $authorizers; } public static function listScvusersByOrgId(int $orgId): Collection { return Scvuser::wherein('groupid', function($query) use ($orgId) { $query->select('id') ->from('scvgroups') ->where('organization_id', $orgId); }) ->get(); } public static function usedByNormalUser($organization_id) { $scvusers = Scvuser::listScvusersByOrgId($organization_id); if($scvusers->count() > 1){ return true; } return false; } private static function countScvusersByOrgId($organization_id) { return Scvuser::select('scvusers.*', 'scvusers.id as user_id') ->join('scvgroups', 'scvusers.groupid', 'scvgroups.id') ->where('scvgroups.organization_id', '=', $organization_id) ->count(); } public static function deleteScvtemplate($organization_id) { $scvuser_count= self::countScvusersByOrgId($organization_id); if($scvuser_count > 1 || $scvuser_count === 0) { return ; } $scvtemplate_user = Scvuser::join('scvgroups', 'scvusers.groupid', 'scvgroups.id') ->where('scvgroups.organization_id', '=', $organization_id) ->where('scvusers.name', '=', 'scvtemplate') ->addSelect('scvusers.id as scvuser_id') ->first(); $count = Scvuser::destroy($scvtemplate_user->scvuser_id); if (CH::isCluster()) { $slave_count = 0; if (CH::isSlaveActive()) { $slave_count = self::on('slave_database')->find($scvtemplate_user->scvuser_id)->delete(); } CH::updateClusters($count > 0, $slave_count > 0); } return $count; } } 