<?php
 namespace App; use Illuminate\Database\Eloquent\Model; use App\Libs\ClusterHelper as CH; use Illuminate\Support\Facades\DB; class ScvxChromeSetting extends Model { protected $guarded = ['id', 'created_at']; protected $casts = [ 'save_profile' => 'boolean', 'save_history' => 'boolean', 'save_password' => 'boolean', 'save_cookie' => 'boolean', 'save_bookmark' => 'boolean', 'hide_internal_pages' => 'boolean', 'enable_xff' => 'boolean' ]; public static function create(array $attributes = []) { $milli_time = floor(microtime(true) * 1000); $scvx_chrome = new ScvxChromeSetting($attributes); $dbret = $scvx_chrome->save(); $slavedbret = ""; if(!$dbret){ \Log::error('ScvxChromeSettingController : store method', ['code' => 'SC01', 'ret' => $dbret]); \Session::flash('flash_msg', 'データベース処理に失敗しました。 : SC01'); return redirect()->back()->withInput(); } $organization_name = Organization::find($scvx_chrome->organization_id)->name; parent::createProfile($scvx_chrome, $organization_name); if(CH::isCluster()){ if(CH::isMasterActive() && $dbret){ if(CH::isSlaveAlive() && CH::isSlaveActive()){ $slave_set = new ScvxChromeSetting($attributes); $slave_set->setConnection('slave_database'); $slavedbret = $slave_set->save(); } DB::table('clusters')->lockForUpdate()->where('role','MASTER')->update(['tpl_updatemill' => $milli_time]); } CH::updateClusters($dbret,$slavedbret,$milli_time); } } public static function updateSetting(array $attributes = [], $id) { $milli_time = floor(microtime(true) * 1000); $scvx_chrome = parent::find($id); $before_organization_name = Organization::find($scvx_chrome->organization_id)->name; $before_chrome_name = $scvx_chrome->name; $dbret = $scvx_chrome->fill($attributes)->save(); $slavedbret = ""; if(!$dbret){ \Log::error('ScvxChromeController : update method', ['code' => 'SC01', 'ret' => $dbret]); \Session::flash('flash_msg', 'データベース処理に失敗しました。 : SC01'); return redirect()->back()->withInput(); } $organization_name = Organization::find($scvx_chrome->organization_id)->name; parent::createProfile($scvx_chrome, $organization_name); $before_cert_path = "/var/www/html/scv/scvtemplates/".$before_organization_name."/".$before_chrome_name."/cert"; $certs_csv_path = "/var/www/html/scv/scvtemplates/".$before_organization_name."/".$before_chrome_name."/certs.csv"; $after_cert_path = "/var/www/html/scv/scvtemplates/".$organization_name."/".$scvx_chrome->name."/cert"; $after_certs_csv_path = "/var/www/html/scv/scvtemplates/".$organization_name."/".$scvx_chrome->name."/certs.csv"; if (file_exists($before_cert_path)) { rename($before_cert_path, $after_cert_path); chown($after_cert_path, "www-data"); chgrp($after_cert_path, "docker"); } if (file_exists($certs_csv_path)) { rename($certs_csv_path, $after_certs_csv_path); chown($after_certs_csv_path, "www-data"); chgrp($after_certs_csv_path, "docker"); } if ($before_organization_name != $organization_name || $before_chrome_name != $scvx_chrome->name ) { $before_prof_path = "/var/www/html/scv/scvtemplates/".$before_organization_name."/".$before_chrome_name; exec("rm -rf ${before_prof_path}"); } if(CH::isCluster()){ if(CH::isMasterActive() && $dbret){ if(CH::isSlaveAlive() && CH::isSlaveActive()){ $slave_set = self::on('slave_database')->find($id); $slavedbret = $slave_set->fill($attributes)->save(); } DB::table('clusters')->lockForUpdate()->where('role','MASTER')->update(['tpl_updatemill' => $milli_time]); } CH::updateClusters($dbret,$slavedbret,$milli_time); } } public static function destroy($ids) { $setting = parent::find($ids); $name = $setting->name; $organization = Organization::find($setting->organization_id); $dbret = $setting->delete(); $slavedbret = ""; if(!$dbret){ \Session::flash('flash_msg', 'データベース処理に失敗しました。'); return redirect()->back()->withInput(); } if(CH::isCluster()){ $milli_time = floor(microtime(true) * 1000); if(CH::isMasterActive() && $dbret){ if(CH::isSlaveAlive() && CH::isSlaveActive()){ $slavemodel = new ScvxChromeSetting; $slavemodel->setConnection('slave_database'); $tmp = $slavemodel->where('name', '=', $name)->first(); $slaveid = $tmp->id; $slave_set = $slavemodel->find($slaveid); $slavedbret = $slave_set->delete(); } DB::table('clusters')->lockForUpdate()->where('role','MASTER')->update(['tpl_updatemill' => $milli_time]); } CH::updateClusters($dbret,$slavedbret,$milli_time); } $path = "/var/www/html/scv/scvtemplates/".$organization->name."/".$name; if(file_exists($path)){ exec("rm -rf $path"); } } public static function createProfile($scvx_chrome, $organization_name) { $organization_path = "/var/www/html/scv/scvtemplates/".$organization_name; $setting_path = "/var/www/html/scv/scvtemplates/".$organization_name."/".$scvx_chrome->name; $policy_engine_file = $setting_path."/policies.json"; $extension_file = $setting_path."/extension.json"; if(!file_exists($setting_path)){ mkdir($setting_path, 0777, true); chown($setting_path,"www-data"); chgrp($setting_path,"docker"); chmod($setting_path, 0770); chown($organization_path,"www-data"); chgrp($organization_path,"docker"); chmod($organization_path, 0770); } if(is_readable($policy_engine_file)){ $policy_obj = json_decode(file_get_contents($policy_engine_file)); if($policy_obj == null){ \Session::flash('flash_msg', '<p style="color:red;">policies.jsonの書き込みに失敗しました。</p>'); return; } } else { $policy_obj = json_decode('{}'); } $policy_obj->DeveloperToolsAvailability = 2; $policy_obj->ShowHomeButton = true; $policy_obj->IncognitoModeAvailability = 1; $policy_obj->BrowserGuestModeEnabled = false; $policy_obj->HardwareAccelerationModeEnabled = false; $policy_obj->RoamingProfileSupportEnabled = false; $policy_obj->ComponentUpdatesEnabled = false; $policy_obj->DisablePrintPreview = false; $policy_obj->SuppressUnsupportedOSWarning = true; $policy_obj->BrowserSignin = 0; $policy_obj->DefaultCookiesSetting = 1; $policy_obj->BlockThirdPartyCookies = false; $es = json_decode('{"extension_id":{"toolbar_pin":"force_pinned"}}'); $policy_obj->ExtensionSettings = $es; $ub = json_decode('["chrome://*","chrome.google.com/webstore","view-source:*"]'); $policy_obj->URLBlocklist = $ub; $policy_obj->RestoreOnStartup = 4; $policy_obj->HomepageIsNewTabPage = false; if (empty($scvx_chrome->homepage)){ $scvx_chrome->homepage = "chrome://newtab"; } $policy_obj->HomepageLocation = $scvx_chrome->homepage; $url_array = explode(" ", $scvx_chrome->startup_page); $url_result = json_decode('[]'); foreach ($url_array as $url) { if (!empty($url)){ array_push($url_result, $url); } } $policy_obj->RestoreOnStartupURLs = $url_result; $bm = json_decode('[]'); $flg = true; foreach(json_decode($scvx_chrome->bookmarks) as $b){ $bm_part = json_decode('{"name":{},"url":{}}'); $bm_part->name = $b->Title; $bm_part->url = $b->URL; $bm_all = $bm_part; if($b->Folder){ $bm_all = json_decode('{"name":{},"children":{}}'); foreach ($bm as $n) { if($n->name === $b->Folder){ array_push($n->children, $bm_part); $bm_all = null; break; }else { $bm_all->name = $b->Folder; $bm_all->children = [$bm_part]; } } if($flg){ $bm_all->name = $b->Folder; $bm_all->children = [$bm_part]; } } if($bm_all != null){ array_push($bm, $bm_all); } $flg = false; } $bmtop = json_decode('{"toplevel_name":{}}'); $bmtop->toplevel_name = $scvx_chrome->bookmark_toplevel; array_push($bm, $bmtop); $policy_obj->ManagedBookmarks = $bm; $ps = json_decode('{}'); if($scvx_chrome->proxy_type == 0){ $ps->ProxyMode = "direct"; } else if($scvx_chrome->proxy_type == 1){ $ps->ProxyBypassList = $scvx_chrome->no_proxy_host; $ps->ProxyMode = "fixed_servers"; if($scvx_chrome->http_proxy_host && $scvx_chrome->http_proxy_port){ $ps->ProxyServer = "http=$scvx_chrome->http_proxy_host:$scvx_chrome->http_proxy_port"; if($scvx_chrome->ssl_proxy_host && $scvx_chrome->ssl_proxy_port){ $ps->ProxyServer = "http=$scvx_chrome->http_proxy_host:$scvx_chrome->http_proxy_port;https=$scvx_chrome->ssl_proxy_host:$scvx_chrome->ssl_proxy_port"; } } else if($scvx_chrome->ssl_proxy_host && $scvx_chrome->ssl_proxy_port){ $ps->ProxyServer = "https=$scvx_chrome->ssl_proxy_host:$scvx_chrome->ssl_proxy_port"; } } else { $ps->ProxyMode = "pac_script"; $ps->ProxyPacUrl = $scvx_chrome->proxy_url; } $policy_obj->ProxySettings = $ps; $ua = ["chrome://new-tab-page", "chrome://newtab", "chrome://history", "chrome://bookmarks", "chrome://print", "chrome://downloads"]; if(!$scvx_chrome->hide_internal_pages){ array_push($ua, "chrome://settings"); } $policy_obj->URLAllowlist = $ua; $policy_obj->PasswordManagerEnabled = (bool)$scvx_chrome->save_password; $policy_engine_json = json_encode($policy_obj, JSON_PRETTY_PRINT|JSON_UNESCAPED_SLASHES); file_put_contents($policy_engine_file, $policy_engine_json); chown($policy_engine_file,"www-data"); chgrp($policy_engine_file,"docker"); chmod($policy_engine_file, 0660); parent::setExtensionSettings($scvx_chrome, $organization_name); } public static function setExtensionSettings($scvx_chrome, $organization_name) { $path = "/var/www/html/scv/scvtemplates/".$organization_name."/".$scvx_chrome->name; $settings_file = $path."/extension_settings.json"; $obj = json_decode('{}'); $obj->max_tab = $scvx_chrome->max_tab; $obj->xff = (bool)$scvx_chrome->xff_flag; $obj->download_dir = $scvx_chrome->downloaddir; $obj->save_profile = (bool)$scvx_chrome->save_profile; $obj->save_history = (bool)$scvx_chrome->save_history; $obj->save_cookie = (bool)$scvx_chrome->save_cookie; $obj->save_password = (bool)$scvx_chrome->save_password; $obj->save_bookmark = (bool)$scvx_chrome->save_bookmark; $obj->proxy_auth = (bool)$scvx_chrome->enable_pauth; if($scvx_chrome->pauth_user) { $obj->pauth_account = $scvx_chrome->pauth_user.":".$scvx_chrome->pauth_pass; } $json = json_encode($obj, JSON_PRETTY_PRINT|JSON_UNESCAPED_SLASHES); file_put_contents($settings_file, $json); chown($settings_file,"www-data"); chgrp($settings_file,"docker"); chmod($settings_file, 0660); } public static function certData($profile_name, $organization_name) { $path = "/var/www/html/scv/scvtemplates/".$organization_name."/".$profile_name."/certs.csv"; $files = array(); if(file_exists($path)){ $text = file_get_contents($path); $files = array_values(array_filter(explode("\n", $text))); }else{ $files = array(); } return $files; } public static function certSave($setting, $organization_name, $file, $password) { $base_dir = "/var/www/html/scv/scvtemplates/".$organization_name."/".$setting->name; $path = $base_dir."/cert"; $fn = $file->getClientOriginalName(); $file->move($path, $fn); if($password){ $password = exec("/var/www/html/scv/scvbin/scvstr -e -- '$password'"); } $certs_file = $base_dir."/certs.csv"; $md5 = md5_file($path."/".$fn); $mt = microtime(true) * 10000; $first = $md5."_".$mt; file_put_contents($certs_file, "$first,$fn,$password\n", FILE_APPEND); if(CH::isCluster()){ $milli_time = floor(microtime(true) * 1000); DB::table('clusters')->lockForUpdate()->where('role','MASTER')->update(['tpl_updatemill' => $milli_time]); } } public static function certDelete($fn, $prof_name, $organization_name) { $base_dir = "/var/www/html/scv/scvtemplates/".$organization_name."/".$prof_name; $certs_file = $base_dir."/certs.csv"; $fb = file_get_contents($base_dir."/certs.csv"); $t = preg_quote($fn); $new_fb = preg_replace("/.*$t.*\n/", '', $fb); file_put_contents($certs_file, $new_fb); unlink($base_dir."/cert/".$fn); if(CH::isCluster()){ $milli_time = floor(microtime(true) * 1000); DB::table('clusters')->lockForUpdate()->where('role','MASTER')->update(['tpl_updatemill' => $milli_time]); } } public function getPauthPassAttribute($value) { if ($value === 'SCVUSER') { return $value; } $clear = exec("scvstr -d -- '$value'"); return $clear; } public function getPauthPassCipherAttribute() { return $this->attributes['pauth_pass']; } public function setPauthPassAttribute($value) { $pass = null; if ($value == "") { $pass = ""; } else if ($value === 'SCVUSER') { $pass = 'SCVUSER'; } else { $value = escapeshellarg($value); $cipher = exec("scvstr -e -- $value"); $pass = $cipher; } $this->attributes['pauth_pass'] = $pass; } public static function getChromeSettingsWithOrg() { return ScvxChromeSetting::select('scvx_chrome_settings.*') ->join('organizations', 'scvx_chrome_settings.organization_id', 'organizations.id') ->addselect('organizations.name as organization_name') ->get(); } public static function getChromeSettingsByOrg($organization_id) { return ScvxChromeSetting::select('scvx_chrome_settings.*') ->join('organizations', 'scvx_chrome_settings.organization_id', 'organizations.id') ->addselect('organizations.name as organization_name') ->where('organizations.id', $organization_id) ->get(); } public static function getChromeSettingWithOrgById($chrome_setting_id) { return ScvxChromeSetting::select('scvx_chrome_settings.*') ->join('organizations', 'scvx_chrome_settings.organization_id', 'organizations.id') ->addselect('organizations.name as organization_name') ->where('scvx_chrome_settings.id', $chrome_setting_id) ->first(); } public static function getChromeSettingAndOrgByName($profile_name, $organization_id) { return ScvxChromeSetting::select('scvx_chrome_settings.name') ->join('organizations', 'scvx_chrome_settings.organization_id', '=', 'organizations.id') ->addselect('organizations.name as organization_name') ->where('scvx_chrome_settings.name', '=', $profile_name) ->where('organizations.id', '=', $organization_id) ->first(); } public static function usedByChromeprofile($organization_id) { if(ScvxChromeSetting::where('organization_id', '=', $organization_id)->count() > 0) { return true; } return false; } } 