<?php
declare(strict_types = 1); namespace App\Services\Auth; use Exception; class AuthFailedException extends Exception { const USER_NOT_FOUND = 1; const INVALID_CREDENTIAL = 2; const USER_IS_LOCKED = 3; const PASSWORD_EXPIRED = 4; const AUTH_FAILED = 5; const NOT_IMPLEMENTED = 10; const UNKNOWN = 20; const REASONS = [ self::USER_NOT_FOUND => 'ユーザ名またはパスワードが違います。', self::INVALID_CREDENTIAL => 'ユーザ名またはパスワードが違います。', self::USER_IS_LOCKED => 'このユーザはロックされています。', self::PASSWORD_EXPIRED => 'パスワードの有効期限が切れています。', self::AUTH_FAILED => 'ログインに失敗しました。', self::NOT_IMPLEMENTED => 'システムエラー', self::UNKNOWN => '不明なエラー', ]; function __construct(int $code) { if (!array_key_exists($code, self::REASONS)) { $code = self::UNKNOWN; } $message = self::REASONS[$code]; parent::__construct($message, $code); } } 