<?php
declare(strict_types = 1); namespace App\Services\Auth; use App\Libs\ScvPasswordHelper; use App\Scvuser; class KerberosAuth implements ScvUserAuthInterface { public function auth(string $org, string $user, string $plainPassword): Scvuser { $scvuser = Scvuser::with_org($org, $user); if (is_null($scvuser)) { throw new AuthFailedException(AuthFailedException::USER_NOT_FOUND); } $encPassword = ScvPasswordHelper::encode($plainPassword); $isOk = $this->scvkerberos($user, $encPassword, $org); if (!$isOk) { throw new AuthFailedException(AuthFailedException::AUTH_FAILED); } return $scvuser; } function scvkerberos(string $username, string $encPassword, string $realm): bool { $escUsername = escapeshellarg($username); $escEncPassword = escapeshellarg($encPassword); $escRealm = escapeshellarg($realm); $result = exec("scvkerberos -auth $escUsername $escEncPassword $escRealm"); if ($this->startsWith($result, 'STAT:LOGIN_SUCCESS')) { return true; } elseif ($this->startsWith($result, 'STAT:CONFIG_READ_ERROR')) { throw new AuthFailedException(AuthFailedException::AUTH_FAILED); } elseif ($this->startsWith($result, 'STAT:NOT_DECRYPTED')) { throw new AuthFailedException(AuthFailedException::AUTH_FAILED); } elseif ($this->startsWith($result, 'STAT:LOGIN_FAILURE_12')) { throw new AuthFailedException(AuthFailedException::PASSWORD_EXPIRED); } elseif ($this->startsWith($result, 'STAT:LOGIN_FAILURE')) { throw new AuthFailedException(AuthFailedException::INVALID_CREDENTIAL); } } private function startsWith(string $haystack, string $needle): bool { return strpos($haystack, $needle) === 0; } } 