<?php
declare(strict_types = 1); namespace App\Services\Auth; use App\Models\LdapSetting; use App\Libs\LdapHelper; use App\Organization; use App\Scvuser; class LdapAuth implements ScvUserAuthInterface { function auth(string $org, string $user, string $plainPassword): Scvuser { $scvuser = Scvuser::with_org($org, $user); if (is_null($scvuser)) { throw new AuthFailedException(AuthFailedException::USER_NOT_FOUND); } $organization = Organization::findByName($org); $ldapSetting = LdapSetting::findByOrganizationId($organization->id); if (!$ldapSetting) { throw new AuthFailedException(AuthFailedException::INVALID_CREDENTIAL); } if (LdapHelper::ldapauth($ldapSetting, $scvuser->name, $plainPassword)) { return $scvuser; } else { throw new AuthFailedException(AuthFailedException::INVALID_CREDENTIAL); } } } 