<?php
declare(strict_types = 1); namespace App\Services\Auth; use App\Libs\PasswordPolicyManager; use App\Scvuser; class LocalAuth implements ScvUserAuthInterface { function auth(string $org, string $user, string $plainPassword): Scvuser { $scvuser = Scvuser::attemptScvLogin("{$org}/{$user}", $plainPassword); if (is_null($scvuser)) { throw new AuthFailedException(AuthFailedException::USER_NOT_FOUND); } if ($scvuser->locked) { throw new AuthFailedException(AuthFailedException::USER_IS_LOCKED); } if ($this->isPasswordExpired($scvuser)) { throw new AuthFailedException(AuthFailedException::PASSWORD_EXPIRED); } if (!$scvuser->login_success) { throw new AuthFailedException(AuthFailedException::INVALID_CREDENTIAL); } return $scvuser; } private function isPasswordExpired($scvuser): bool { $ppm = new PasswordPolicyManager($scvuser->organization, $scvuser->name); return $ppm->expired(); } } 