<?php
 namespace App\Traits; use Illuminate\Support\Facades\Auth; use App\Libs\ConfHelper; use App\Scvuser; use App\Scvflow; use App\Exceptions\SamlException; trait ScvFlowCtrl { public function login_user() { return Auth::guard('scvuser')->user(); } public function is_authorizer() { $login_user = $this->login_user(); return $login_user && $login_user->privilege; } public function is_authorizer_of($dl_key) { if (!$this->is_authorizer()) return false; $login_user_id = $this->login_user()->id; $authorizer_id = Scvflow::get_request($dl_key)->authorizer_id; return $login_user_id === $authorizer_id; } public function home_redirect($msg = '', $success = false) { $redirect = redirect()->route('scvflow.home'); return $this->common_redirect($redirect, $msg, $success); } public function same_redirect($msg = '', $success = false) { $redirect = redirect(\Request::url()); return $this->common_redirect($redirect, $msg, $success); } public function back_redirect($msg = '', $success = false) { $redirect = redirect()->back(); return $this->common_redirect($redirect, $msg, $success); } private function common_redirect($redirect, $msg, $success) { if (is_array($success)) { $okmsg = $msg; $errmsgs = $success; return $redirect->with('okmsg', $msg)->withErrors($errmsgs); } else { if ($success) return $redirect->with('okmsg', $msg); else return $redirect->withErrors([$msg]); } } private function login_with_saml($user, $domain) { $org = strtoupper($domain); $scvuser = Scvuser::with_org($org, $user); if ($scvuser !== null) Auth::guard('scvuser')->loginUsingId($scvuser->user_id); else throw new SamlException('ADFSのユーザに対応するSCVユーザが登録されていません'); } }