<?php
 namespace App\Traits; use App\Libs\ClusterHelper; trait SlaveSyncer { private static $slave_connection = 'slave_database'; private static $slave_operating = false; private function sync_to_slave_ifneeds($src, $action) { if (self::$slave_operating) return; if (!ClusterHelper::needsToSyncSlave()) return; self::$slave_operating = true; try { $model = get_class($src); $dest = new $model; $dest = $src->replicate(); $dest->setConnection(self::$slave_connection); switch ($action) { case 'store': $dest->id = $src->id; $slave_ok = $dest->save(); break; case 'update': $cnt = $dest->where('id', $src->id)->update($src->toArray()); $slave_ok = $cnt > 0; break; case 'destroy': $cnt = $dest->where('id', $src->id)->delete(); $slave_ok = $cnt > 0; break; default: throw new \Exception("Invalid action specified '{$action}'."); } ClusterHelper::update_clusters_if_necessary(true, $slave_ok); } catch (\Exception $e) { logger('Something error occured. (in SlaveSyncer::sync_if_needs)'); throw $e; } finally { self::$slave_operating = false; } } }