<?php
 namespace App; use Illuminate\Database\Eloquent\Model; use Illuminate\Support\Facades\DB; use App\Libs\ClusterHelper as CH; use App\Libs\RevoDtApps; use App\Libs\Utils; use App\VpnSetting; class Visionprofile extends Model { protected $fillable = ['name', 'volume_mb', 'allowed_hosts', 'vpn_ipaddr', 'global_vpn_ipaddr', 'vpn_nic_name', 'dns_server_ipaddr', 'shareprofile_id', 'proxy_setting_id', 'wallpaper_id']; public function vpnSettings() { return $this->belongsToMany(VpnSetting::class) ->withPivot('order') ->orderBy('pivot_order'); } private static function createOnTarget($attributes, $target) { $prof = null; DB::connection($target)->beginTransaction(); try { $prof = self::on($target)->create($attributes); if (isset($attributes['vpn_settings'])) { $prof->vpnSettings()->attach($attributes['vpn_settings']); } DB::connection($target)->Commit(); } catch (\Exception $e) { logger($e); DB::connection($target)->rollBack(); } return $prof; } public static function create(array $attributes = []) { $prof = self::createOnTarget($attributes, 'master_database'); if(!$prof) { return false; } if (CH::isCluster()) { $slave_prof = null; if (CH::isSlaveActive()) { $slave_prof = self::createOnTarget($attributes, 'slave_database'); } CH::updateClusters($prof != null, $slave_prof != null); } return $prof; } private static function updateOnTarget($attributes, $id, $target) { $prof = null; DB::connection($target)->beginTransaction(); try { $prof = self::on($target)->find($id); $prof->fill($attributes)->save(); if(isset($attributes['vpn_settings'])) { $prof->vpnSettings()->sync($attributes['vpn_settings']); } else { $prof->vpnSettings()->detach(); } DB::connection($target)->Commit(); } catch (\Exception $e) { logger($e); DB::connection($target)->rollBack(); } return $prof; } public static function updateSetting($params, $id) { $prof = self::updateOnTarget($params, $id, 'master_database'); if (CH::isCluster()) { $s_ret = false; if (CH::isSlaveActive()) { $s_ret = self::updateOnTarget($params, $id, 'slave_database'); } CH::updateClusters($prof != false, $s_ret); } return $prof; } private static function destroyOnTarget($ids, $target) { $count = null; $prof = self::on($target)->find($ids); $count = $prof->delete(); return $count; } public static function destroy($ids) { $count = self::destroyOnTarget($ids, 'master_database'); if (CH::isCluster()) { $slave_count = 0; if (CH::isSlaveActive()) { $slave_count = self::destroyOnTarget($ids, 'slave_database'); } CH::updateClusters($count > 0, $slave_count > 0); } return $count; } public function getSupportedAppArrayAttribute() { return RevoDtApps::get_supported_apps(); } public function getAllowedAppArrayAttribute() { return RevoDtApps::by_dtobj($this)->get_allowed_apps(); } public function getDeniedAppArrayAttribute() { return RevoDtApps::by_dtobj($this)->get_denied_apps(); } public function getAllowedHostArrayAttribute() { return Utils::split_by_comma($this->allowed_hosts); } public function getAllowedHostTextareaAttribute() { return str_replace(',', "\r\n", $this->allowed_hosts); } public static function isWallpaperUsed(int $wallpaper_id): bool { return self::where('wallpaper_id', $wallpaper_id)->count() > 0; } public static function getVisionprofileByName(string $prof_name) { return Visionprofile::where('name', $prof_name)->first(); } } 