<?php
 namespace App; use Illuminate\Database\Eloquent\Model; use App\BrSetting; use App\Visionprofile; use App\Libs\ClusterHelper as CH; class VpnSetting extends Model { protected $guarded = ['id', 'created_at']; public function brSettings() { return $this->belongsToMany(BrSetting::class); } public function Visionprofiles() { return $this->belongsToMany(Visionprofile::class); } private function formatAllowedHosts($v) { $lines = explode(PHP_EOL, $v); $lines = array_map('trim', $lines); $lines = array_filter($lines, 'strlen'); return implode(',', $lines); } public function setAllowedHostsAttribute($value) { $this->attributes['allowed_hosts'] = $this->formatAllowedHosts($value); } public function getAllowedHostsForTextAreaAttribute() { return str_replace(',', "\r\n", $this->allowed_hosts); } public static function create(array $attributes = []) { $setting = static::query()->create($attributes); if (CH::isCluster()) { $slave_setting = null; if (CH::isSlaveActive()) { $slave_setting = self::on('slave_database')->create($attributes); } CH::updateClusters($setting != null, $slave_setting != null); } return $setting; } public static function updateVpnSetting($params, $id) { $vpn_setting = parent::find($id); $ret = $vpn_setting->fill($params)->save(); if (CH::isCluster()) { $s_ret = false; if (CH::isSlaveActive()) { $slave_vpn_setting = self::on('slave_database')->find($id); $s_ret = $slave_vpn_setting->fill($params)->save(); } CH::updateClusters($ret, $s_ret); } return $ret; } public static function destroy($ids) { $count = parent::destroy($ids); if (CH::isCluster()) { $slave_count = 0; if (CH::isSlaveActive()) { $slave_count = self::on('slave_database')->find($ids)->delete(); } CH::updateClusters($count > 0, $slave_count > 0); } return $count; } } 