<?php
 namespace App\revobr; use Illuminate\Database\Eloquent\Model; use App\Libs\ClusterHelper as CH; class BrUpdateModule extends Model { protected $guarded = ['created_at', 'updated_at']; const MODULE_TYPE_UPDATER = 0x02; const MODULE_TYPE_CLIENT = 0x04; const MODULE_TYPE_FIREFOX = 0x08; const MODULE_TYPE_CHROME = 0x10; const MODULE_TYPE_EXTENSION = 0x20; public static function create(array $attributes = []) { $module = static::query()->create($attributes); if(CH::isCluster()){ $slave_module = null; if(CH::isSlaveActive()){ $slave_module = parent::on('slave_database')->create($module->toArray()); } CH::updateTplUpdatemill(); CH::updateClusters($module != null, $slave_module != null); } return $module; } public static function getModulesCollection() { $modules = parent::all(); $obj = new \stdClass(); $obj->clients = $modules->filter(function($value, $key){ return $value->type == self::MODULE_TYPE_CLIENT; }); $obj->updaters = $modules->filter(function($value, $key){ return $value->type == self::MODULE_TYPE_UPDATER; }); $obj->firefoxes = $modules->filter(function($value, $key){ return $value->type == self::MODULE_TYPE_FIREFOX; }); $obj->chromes = $modules->filter(function($value, $key){ return $value->type == self::MODULE_TYPE_CHROME; }); $obj->extensions = $modules->filter(function($value, $key){ return $value->type == self::MODULE_TYPE_EXTENSION; }); return $obj; } public function scopeInitializeSpecified($query, $type) { return $query->where('type', $type)->update(['specified' => false]); } public function scopeSetSpecified($query, $fname) { return $query->where('file_name', $fname)->update(['specified' => true]); } public static function updateSpecifiedColumn($params) { $type = $params['type']; $fname = $params['file_name']; $init = self::initializeSpecified($type); $set = self::setSpecified($fname); $updated = ($init & $set) > 0 ; if(CH::isCluster()){ $slave_updated = false; if(CH::isSlaveActive()){ $s_init = self::on('slave_database')->initializeSpecified($type); $s_set = self::on('slave_database')->setSpecified($fname); $slave_updated = ($s_init & $s_set) > 0; } CH::updateTplUpdatemill(); CH::updateClusters($updated, $slave_updated); } return $updated; } public static function deleteRecordAndFile($id) { $module = parent::find($id); @unlink($module->save_location); $ret = $module->delete() > 0; if(CH::isCluster()){ $s_ret = false; if(CH::isSlaveActive()){ $s_ret = parent::on('slave_database')->find($id)->delete() > 0; } CH::updateTplUpdatemill(); CH::updateClusters($ret, $s_ret); } return $ret; } public static function getSpecifiedModulesVersion() { $modules = parent::where('specified', 1)->get(); $versions = new \stdClass(); $versions->client = "0"; $versions->updater = "0"; $versions->firefox = "0"; $versions->chrome = "0"; $versions->extension = "0"; if(!$modules->isEmpty()){ $client = $modules->filter(function ($value, $key){ return $value->type == self::MODULE_TYPE_CLIENT; })->first(); $versions->client = $client ? $client->version : "0"; $updater = $modules->filter(function ($value, $key){ return $value->type == self::MODULE_TYPE_UPDATER; })->first(); $versions->updater = $updater ? $updater->version : "0"; $firefox = $modules->filter(function ($value, $key){ return $value->type == self::MODULE_TYPE_FIREFOX; })->first(); $versions->firefox = $firefox ? $firefox->version : "0"; $chrome = $modules->filter(function ($value, $key){ return $value->type == self::MODULE_TYPE_CHROME; })->first(); $versions->chrome = $chrome ? $chrome->version : "0"; $extension = $modules->filter(function ($value, $key){ return $value->type == self::MODULE_TYPE_EXTENSION; })->first(); $versions->extension = $extension ? $extension->version : "0"; } return $versions; } } 