<?php
 namespace App\revobr; use Illuminate\Database\Eloquent\Model; use Carbon\Carbon; use App\Libs\ClusterHelper as CH; class BrUpdatePolicy extends Model { const APP_TYPE_UPDATER = 0x02; const APP_TYPE_CLIENT = 0x04; const APP_TYPE_FIREFOX = 0x08; const APP_TYPE_CHROME = 0x10; const APP_TYPE_EXTENSION = 0x20; const POLICY_TYPE_DAY = 0; const POLICY_TYPE_INTERVAL = 1; const POLICY_TYPE_WEEKLY = 2; const POLICY_TYPE_MONTHLY = 3; const MATCH_TYPE_IPV4 = 1; const MATCH_TYPE_HOSTNAME = 3; const MATCH_TYPE_SCVGROUP = 8; protected $table = 'br_update_policies'; protected $guarded = ['created_at', 'updated_at']; public function getScheduledTimePeriodAttribute($minutes){ return $minutes / 60; } public function setScheduledTimePeriodAttribute($hours){ $this->attributes['scheduled_time_period'] = $hours * 60; } public function getScheduledStartTimeAttribute($time){ return Carbon::parse($this->attributes['scheduled_start_time'])->format('H:i'); } public function setTargetApplicationAttribute($pattern){ if(is_array($pattern)){ $this->attributes['target_application'] = array_sum($pattern) + 1; }else{ $this->attributes['target_application'] = $pattern; } } public function getTargetApplicationAttribute($num){ $pattern = [ self::APP_TYPE_UPDATER, self::APP_TYPE_CLIENT, self::APP_TYPE_FIREFOX, self::APP_TYPE_CHROME, self::APP_TYPE_EXTENSION ]; $a = array(); foreach ($pattern as $p) { if($num & $p) array_push($a, $p); } return $a; } public static function create(array $attributes = []) { $policy = static::query()->create($attributes); static::where('id', '>', 0)->increment('order'); if(CH::isCluster()){ $slave_policy = null; if(CH::isSlaveActive()){ $slave_policy = self::on('slave_database')->create($policy->toArray()); self::on('slave_database')->where('id', '>', 0)->increment('order'); } CH::updateTplUpdatemill(); CH::updateClusters($policy != null, $slave_policy != null); } return $policy; } public static function updatePolicy($params, $id) { $pol = BrUpdatePolicy::find($id); $ret = $pol->fill($params)->save(); if(CH::isCluster()){ $s_ret = false; if(CH::isSlaveActive()){ $slave_pol = BrUpdatePolicy::on('slave_database')->find($id); $s_ret = $slave_pol->fill($params)->save(); } CH::updateTplUpdatemill(); CH::updateClusters($ret, $s_ret); } } private static function appendViewField($pol) { $dayOfWeek = array("", "日", "月", "火", "水", "木", "金", "土"); $applications = array( self::APP_TYPE_UPDATER => "アップデータ", self::APP_TYPE_CLIENT => "クライアント", self::APP_TYPE_FIREFOX => "Firefox", self::APP_TYPE_CHROME => "Chrome", self::APP_TYPE_EXTENSION => "Extension" ); if($pol->scheduled_day != '0000-00-00'){ $pol->scheduled_string = $pol->scheduled_day; $pol->type = self::POLICY_TYPE_DAY; }else if($pol->scheduled_interval){ $pol->scheduled_string = $pol->scheduled_interval. "日毎"; $pol->type = self::POLICY_TYPE_INTERVAL; }else if($pol->scheduled_weekly){ $pol->scheduled_string = "毎週".$dayOfWeek[$pol->scheduled_weekly]."曜日"; $pol->type = self::POLICY_TYPE_WEEKLY; }else if($pol->scheduled_monthly){ $pol->scheduled_string = "毎月".$pol->scheduled_monthly."日"; $pol->type = self::POLICY_TYPE_MONTHLY; } $app_str = ""; foreach ($pol->target_application as $app_number) { $app_str .= $applications[$app_number] . ", "; } $app_str = rtrim($app_str, ', '); $pol->target_application_string = $app_str; if($pol->hide_update_menu) $pol->hide_update_menu_string = "非表示"; else $pol->hide_update_menu_string = "表示"; $match_types = array("Any", "IPv4", "IPv6", "ホスト名", "ユーザ名", "オーナー", "サイト", "ロケーション", "グループ"); if($pol->match_type == 0){ $pol->match_type_string = "Any"; }else{ $pol->match_type_string = $match_types[$pol->match_type]." : ".$pol->match_value; } return $pol; } public static function convertForView($id = null) { if($id){ $pol = parent::find($id); return $pol === null ? null : self::appendViewField($pol); }else{ $bup = parent::all()->sortBy('order'); foreach ($bup as &$pol) { self::appendViewField($pol); } return $bup; } } public static function destroy($ids) { $count = parent::destroy($ids); if(CH::isCluster()){ $slave_count = 0; if(CH::isSlaveActive()){ $slave_count = self::on('slave_database')->find($ids)->delete(); } CH::updateTplUpdatemill(); CH::updateClusters($count > 0, $slave_count > 0); } return $count; } public static function sort($records) { foreach ($records as $record) { $pol = BrUpdatePolicy::find($record['id']); $pol->order = $record['index'] + 1; $ret = $pol->save(); } if(CH::isCluster()){ $s_ret = false; if(CH::isSlaveActive()){ foreach ($records as $record) { $pol = BrUpdatePolicy::on('slave_database')->find($record['id']); $pol->order = $record['index'] + 1; $s_ret = $pol->save(); } } CH::updateTplUpdatemill(); CH::updateClusters($ret, $s_ret); } } } 