<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateScvgroupsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
       Schema::create('scvgroups', function (Blueprint $table) {
            $table->increments('id');
            $table->string('name')->unique();
            $table->boolean('enable');
            $table->string('sort');
            $table->string('comment');
            $table->string('dayofweek'); //sun, mon, tue, wed, thu, fri, sat
            $table->string('hour');      //9:00-12:00, 13:00-17:00
            $table->string('applist');   //firefox,app1,app2
            $table->string('runmode');   //USER | HOST | HOST_USER | CID  のどれか
            $table->string('image');     //docker image, if null of default, then use scvimage of scvconf table
            $table->integer('scvroleid');
            $table->boolean('ena_timeout');
            $table->boolean('ena_dayofweek');
            $table->boolean('ena_hour');
            $table->boolean('firefoxsave');
            $table->boolean('copypaste');
            $table->boolean('speaker');
            $table->boolean('microphone');
            $table->boolean('print');
            $table->boolean('transfer');
            $table->boolean('upload');
            $table->boolean('download');
            $table->boolean('scvcdebug')->default('0'); //SCVC DEBUG Mode
            $table->string('scvpriority');
            $table->string('scvquality');
            $table->integer('firefoxprofile_id');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
       Schema::drop('scvgroups');
    }
}
