<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreatePerformancesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('performances', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->timestamp('time')->default(DB::raw('CURRENT_TIMESTAMP'));
            $table->integer('containers');
            $table->integer('cpu_core');
            $table->decimal('load_average1',5,2);
            $table->decimal('load_average5',5,2);
            $table->decimal('load_average15',5,2);
            $table->decimal('cpu_user',5,2);
            $table->decimal('cpu_kernel',5,2);
            $table->decimal('cpu_idle',5,2);
            $table->decimal('io_wait',5,2);
            $table->integer('mem_sys');
            $table->integer('mem_free');
            $table->integer('mem_swap');
            $table->bigInteger('tcp_insegs');
            $table->bigInteger('tcp_outsegs');
            $table->integer('insegs_dif');
            $table->integer('outsegs_dif');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop('performances');
    }
}
