<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateLogsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('logs', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('scv_version');
            $table->string('xpra_version');
            $table->string('container');
            $table->string('application');
            $table->string('scvuser');
            $table->string('hostname');
            $table->string('ipaddress');
            $table->string('message');
            $table->integer('status');
            $table->integer('retried');
            $table->timestamps();
            $table->time('elapsed_at');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop('logs');
    }
}
