<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateClientlogsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('clientlogs', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('stat');
            $table->string('statmsg');
            $table->string('scvuser');
            $table->string('hostname');
            $table->string('ipaddress');
            $table->string('scv_version');
            $table->string('xpra_version');
            $table->string('container');
            $table->string('application');
            $table->timestamp('scvdirect_started');
            $table->timestamp('container_creating');
            $table->timestamp('container_created');
            $table->timestamp('appstart_starting');
            $table->timestamp('xpra_starting');
            $table->timestamp('appstart_started');
            $table->timestamp('container_removed');
            $table->string('container_removed_reason');
            $table->time('elapsed_at');
            $table->string('scvserver');
            $table->integer('cputime1');
            $table->integer('cputime2');
            $table->integer('cpuaverage');
            $table->integer('cpumax');
            $table->integer('mem1');
            $table->integer('mem2');
            $table->integer('memaverage');
            $table->integer('memmax');
            $table->timestamp('created_at')->default(\DB::raw('CURRENT_TIMESTAMP'));
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop('clientlogs');
    }
}
