<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateFirefoxprofTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('firefoxprofiles', function (Blueprint $table) {
            $table->increments('id');
            $table->string('name')->unique();
            $table->boolean('disable_js');
            $table->boolean('js_lock');
            $table->string('homepage');
            $table->boolean('homepage_lock');
            $table->integer('proxy_type');
            $table->boolean('proxy_lock');
            $table->string('http_proxy_host');
            $table->integer('http_proxy_port');
            $table->string('proxy_url');
            $table->boolean('save_history');
            $table->boolean('history_lock');
            $table->boolean('save_password');
            $table->boolean('password_lock');
            $table->boolean('disable_config');
            $table->boolean('disable_accounts');
            $table->boolean('disable_addons');
            $table->boolean('disable_home');
            $table->boolean('disable_preferences');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop('firefoxprofiles');
    }
}
